package org.bukkit.entity;

/**
 * Represents a Ghast.
 */
// Paper start
public interface Ghast extends Flying {

    /**
     * Returns whether the ghast is charging an attack.
     *
     * @return whether the ghast is charging an attack
     */
    boolean isCharging();

    /**
     * Sets whether the ghast is charging an attack.
     * This determines whether the client displays the charging animation.
     *
     * @param charging whether the ghast is charging an attack
     */
    void setCharging(boolean charging);

    /**
     * Returns the explosion power of shot fireballs.
     *
     * @return explosion power of shot fireballs
     */
    int getExplosionPower();

    /**
     * Sets the explosion power of shot fireballs.
     *
     * @param explosionPower explosion power of shot fireballs
     * @throws IllegalArgumentException if the explosion power is less than 0 or greater than 127
     */
    void setExplosionPower(int explosionPower);
    // Paper end
}
