/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerDeathEvent
extends EntityDeathEvent {
    private int newExp = 0;
    private String deathMessage = "";
    private Component adventure$deathMessage;
    private int newLevel = 0;
    private int newTotalExp = 0;
    private boolean keepLevel = false;
    private boolean keepInventory = false;
    private boolean doExpDrop;
    @Deprecated
    private List<ItemStack> itemsToKeep = new ArrayList<ItemStack>();

    public PlayerDeathEvent(@NotNull Player player, @NotNull List<ItemStack> drops, int droppedExp, @Nullable Component adventure$deathMessage) {
        this(player, drops, droppedExp, 0, adventure$deathMessage, null);
    }

    public PlayerDeathEvent(@NotNull Player player, @NotNull List<ItemStack> drops, int droppedExp, int newExp, @Nullable Component adventure$deathMessage, @Nullable String deathMessage) {
        this(player, drops, droppedExp, newExp, 0, 0, adventure$deathMessage, deathMessage);
    }

    public PlayerDeathEvent(@NotNull Player player, @NotNull List<ItemStack> drops, int droppedExp, int newExp, int newTotalExp, int newLevel, @Nullable Component adventure$deathMessage, @Nullable String deathMessage) {
        this(player, drops, droppedExp, newExp, newTotalExp, newLevel, adventure$deathMessage, deathMessage, true);
    }

    public PlayerDeathEvent(@NotNull Player player, @NotNull List<ItemStack> drops, int droppedExp, int newExp, int newTotalExp, int newLevel, @Nullable Component adventure$deathMessage, @Nullable String deathMessage, boolean doExpDrop) {
        super(player, drops, droppedExp);
        this.newExp = newExp;
        this.newTotalExp = newTotalExp;
        this.newLevel = newLevel;
        this.deathMessage = deathMessage;
        this.adventure$deathMessage = adventure$deathMessage;
        this.doExpDrop = doExpDrop;
    }

    public PlayerDeathEvent(@NotNull Player player, @NotNull List<ItemStack> drops, int droppedExp, @Nullable String deathMessage) {
        this(player, drops, droppedExp, 0, deathMessage);
    }

    @Deprecated
    public PlayerDeathEvent(@NotNull Player player, @NotNull List<ItemStack> drops, int droppedExp, int newExp, @Nullable String deathMessage) {
        this(player, drops, droppedExp, newExp, 0, 0, deathMessage);
    }

    @Deprecated
    public PlayerDeathEvent(@NotNull Player player, @NotNull List<ItemStack> drops, int droppedExp, int newExp, int newTotalExp, int newLevel, @Nullable String deathMessage) {
        this(player, drops, droppedExp, newExp, newTotalExp, newLevel, deathMessage, true);
    }

    @Deprecated
    public PlayerDeathEvent(@NotNull Player player, @NotNull List<ItemStack> drops, int droppedExp, int newExp, int newTotalExp, int newLevel, @Nullable String deathMessage, boolean doExpDrop) {
        super(player, drops, droppedExp);
        this.newExp = newExp;
        this.newTotalExp = newTotalExp;
        this.newLevel = newLevel;
        this.deathMessage = deathMessage;
        this.adventure$deathMessage = deathMessage != null ? Bukkit.getUnsafe().legacyComponentSerializer().deserialize(deathMessage) : Component.empty();
    }

    @NotNull
    public List<ItemStack> getItemsToKeep() {
        return this.itemsToKeep;
    }

    public boolean shouldDropExperience() {
        return this.doExpDrop;
    }

    public void setShouldDropExperience(boolean doExpDrop) {
        this.doExpDrop = doExpDrop;
    }

    @Override
    @NotNull
    public Player getEntity() {
        return (Player)this.entity;
    }

    @NotNull
    public Player getPlayer() {
        return this.getEntity();
    }

    public void deathMessage(@Nullable Component deathMessage) {
        this.deathMessage = null;
        this.adventure$deathMessage = deathMessage;
    }

    @Nullable
    public Component deathMessage() {
        return this.adventure$deathMessage;
    }

    @Deprecated
    public void setDeathMessage(@Nullable String deathMessage) {
        this.deathMessage = deathMessage;
        this.adventure$deathMessage = deathMessage != null ? Bukkit.getUnsafe().legacyComponentSerializer().deserialize(deathMessage) : Component.empty();
    }

    @Deprecated
    @Nullable
    public String getDeathMessage() {
        return this.deathMessage != null ? this.deathMessage : (this.adventure$deathMessage != null ? PlayerDeathEvent.getDeathMessageString(this.adventure$deathMessage) : null);
    }

    private static String getDeathMessageString(Component component) {
        return Bukkit.getUnsafe().legacyComponentSerializer().serialize(component);
    }

    public int getNewExp() {
        return this.newExp;
    }

    public void setNewExp(int exp) {
        this.newExp = exp;
    }

    public int getNewLevel() {
        return this.newLevel;
    }

    public void setNewLevel(int level) {
        this.newLevel = level;
    }

    public int getNewTotalExp() {
        return this.newTotalExp;
    }

    public void setNewTotalExp(int totalExp) {
        this.newTotalExp = totalExp;
    }

    public boolean getKeepLevel() {
        return this.keepLevel;
    }

    public void setKeepLevel(boolean keepLevel) {
        this.keepLevel = keepLevel;
    }

    public void setKeepInventory(boolean keepInventory) {
        this.keepInventory = keepInventory;
    }

    public boolean getKeepInventory() {
        return this.keepInventory;
    }
}

