/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.help.HelpMap;
import org.bukkit.help.HelpTopic;
import org.bukkit.help.HelpTopicComparator;
import org.bukkit.help.IndexHelpTopic;
import org.bukkit.util.ChatPaginator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HelpCommand
extends BukkitCommand {
    public HelpCommand() {
        super("help");
        this.description = "Shows the help menu";
        this.usageMessage = "/help <pageNumber>\n/help <topic>\n/help <topic> <pageNumber>";
        this.setAliases(Arrays.asList("?"));
        this.setPermission("bukkit.command.help");
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String currentAlias, @NotNull String[] args) {
        int pageWidth;
        int pageHeight;
        int pageNumber;
        String command;
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            command = "";
            pageNumber = 1;
        } else if (NumberUtils.isDigits((String)args[args.length - 1])) {
            command = StringUtils.join((Object[])ArrayUtils.subarray((Object[])args, (int)0, (int)(args.length - 1)), (String)" ");
            try {
                pageNumber = NumberUtils.createInteger((String)args[args.length - 1]);
            }
            catch (NumberFormatException exception) {
                pageNumber = 1;
            }
            if (pageNumber <= 0) {
                pageNumber = 1;
            }
        } else {
            command = StringUtils.join((Object[])args, (String)" ");
            pageNumber = 1;
        }
        if (sender instanceof ConsoleCommandSender) {
            pageHeight = Integer.MAX_VALUE;
            pageWidth = Integer.MAX_VALUE;
        } else {
            pageHeight = 9;
            pageWidth = 55;
        }
        HelpMap helpMap = Bukkit.getServer().getHelpMap();
        HelpTopic topic = helpMap.getHelpTopic(command);
        if (topic == null) {
            topic = helpMap.getHelpTopic("/" + command);
        }
        if (topic == null) {
            topic = this.findPossibleMatches(command);
        }
        if (topic == null || !topic.canSee(sender)) {
            sender.sendMessage(ChatColor.RED + "No help for " + command);
            return true;
        }
        ChatPaginator.ChatPage page = ChatPaginator.paginate(topic.getFullText(sender), pageNumber, pageWidth, pageHeight);
        StringBuilder header = new StringBuilder();
        header.append((Object)ChatColor.YELLOW);
        header.append("--------- ");
        header.append((Object)ChatColor.WHITE);
        header.append("Help: ");
        header.append(topic.getName());
        header.append(" ");
        if (page.getTotalPages() > 1) {
            header.append("(");
            header.append(page.getPageNumber());
            header.append("/");
            header.append(page.getTotalPages());
            header.append(") ");
        }
        header.append((Object)ChatColor.YELLOW);
        for (int i = header.length(); i < 55; ++i) {
            header.append("-");
        }
        sender.sendMessage(header.toString());
        sender.sendMessage(page.getLines());
        return true;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            ArrayList<String> matchedTopics = new ArrayList<String>();
            String searchString = args[0];
            for (HelpTopic topic : Bukkit.getServer().getHelpMap().getHelpTopics()) {
                String trimmedTopic;
                if (!topic.canSee(sender) || !(trimmedTopic = topic.getName().startsWith("/") ? topic.getName().substring(1) : topic.getName()).startsWith(searchString)) continue;
                matchedTopics.add(trimmedTopic);
            }
            return matchedTopics;
        }
        return ImmutableList.of();
    }

    @Nullable
    protected HelpTopic findPossibleMatches(@NotNull String searchString) {
        int maxDistance = searchString.length() / 5 + 3;
        TreeSet<HelpTopic> possibleMatches = new TreeSet<HelpTopic>(HelpTopicComparator.helpTopicComparatorInstance());
        if (searchString.startsWith("/")) {
            searchString = searchString.substring(1);
        }
        for (HelpTopic topic : Bukkit.getServer().getHelpMap().getHelpTopics()) {
            String trimmedTopic = topic.getName().startsWith("/") ? topic.getName().substring(1) : topic.getName();
            if (trimmedTopic.length() < searchString.length() || Character.toLowerCase(trimmedTopic.charAt(0)) != Character.toLowerCase(searchString.charAt(0)) || HelpCommand.damerauLevenshteinDistance(searchString, trimmedTopic.substring(0, searchString.length())) >= maxDistance) continue;
            possibleMatches.add(topic);
        }
        if (possibleMatches.size() > 0) {
            return new IndexHelpTopic("Search", null, null, possibleMatches, "Search for: " + searchString);
        }
        return null;
    }

    protected static int damerauLevenshteinDistance(@Nullable String s1, @Nullable String s2) {
        int INF;
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 != null && s2 == null) {
            return s1.length();
        }
        if (s1 == null && s2 != null) {
            return s2.length();
        }
        int s1Len = s1.length();
        int s2Len = s2.length();
        int[][] H = new int[s1Len + 2][s2Len + 2];
        H[0][0] = INF = s1Len + s2Len;
        for (int i = 0; i <= s1Len; ++i) {
            H[i + 1][1] = i;
            H[i + 1][0] = INF;
        }
        for (int j = 0; j <= s2Len; ++j) {
            H[1][j + 1] = j;
            H[0][j + 1] = INF;
        }
        HashMap<Character, Integer> sd = new HashMap<Character, Integer>();
        for (char Letter : (s1 + s2).toCharArray()) {
            if (sd.containsKey(Character.valueOf(Letter))) continue;
            sd.put(Character.valueOf(Letter), 0);
        }
        for (int i = 1; i <= s1Len; ++i) {
            int DB = 0;
            for (int j = 1; j <= s2Len; ++j) {
                int i1 = (Integer)sd.get(Character.valueOf(s2.charAt(j - 1)));
                int j1 = DB;
                if (s1.charAt(i - 1) == s2.charAt(j - 1)) {
                    H[i + 1][j + 1] = H[i][j];
                    DB = j;
                } else {
                    H[i + 1][j + 1] = Math.min(H[i][j], Math.min(H[i + 1][j], H[i][j + 1])) + 1;
                }
                H[i + 1][j + 1] = Math.min(H[i + 1][j + 1], H[i1][j1] + (i - i1 - 1) + 1 + (j - j1 - 1));
            }
            sd.put(Character.valueOf(s1.charAt(i - 1)), i);
        }
        return H[s1Len + 1][s2Len + 1];
    }
}

