/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chat;

import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ChatRenderer {
    @ApiStatus.OverrideOnly
    @NotNull
    public Component render(@NotNull Player var1, @NotNull Component var2, @NotNull Component var3, @NotNull Audience var4);

    @NotNull
    public static ChatRenderer defaultRenderer() {
        return ChatRenderer.viewerUnaware((source, sourceDisplayName, message) -> Component.translatable((String)"chat.type.text", (ComponentLike[])new ComponentLike[]{sourceDisplayName, message}));
    }

    @NotNull
    public static ChatRenderer viewerUnaware(final @NotNull ViewerUnaware renderer) {
        return new ChatRenderer(){
            private @MonotonicNonNull Component message;

            @Override
            @NotNull
            public Component render(@NotNull Player source, @NotNull Component sourceDisplayName, @NotNull Component message, @NotNull Audience viewer) {
                if (this.message == null) {
                    this.message = renderer.render(source, sourceDisplayName, message);
                }
                return this.message;
            }
        };
    }

    public static interface ViewerUnaware {
        @ApiStatus.OverrideOnly
        @NotNull
        public Component render(@NotNull Player var1, @NotNull Component var2, @NotNull Component var3);
    }
}

