/*
 * Decompiled with CFR 0.152.
 */
package com.github.puregero.multilib.bukkit;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class StoredData {
    private long lastLogin;
    private final UUID uuid;
    private final ScheduledThreadPoolExecutor scheduler;
    private final Map<String, String> data = new HashMap<String, String>();
    private final Map<String, String> persistentData = new HashMap<String, String>();
    private boolean needsSaving = false;
    private ScheduledFuture<?> saveFuture = null;

    public StoredData(UUID uuid, long lastLogin, ScheduledThreadPoolExecutor scheduler) {
        this.uuid = uuid;
        this.lastLogin = lastLogin;
        this.scheduler = scheduler;
        this.load();
    }

    private File getFile() {
        return new File("multilib-data/" + this.uuid + ".json");
    }

    private void load() {
        if (this.getFile().isFile()) {
            try {
                YamlConfiguration configuration = new YamlConfiguration();
                configuration.load(this.getFile());
                for (String key : configuration.getKeys(true)) {
                    this.persistentData.put(key, configuration.getString(key));
                }
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public void save() {
        if (this.needsSaving) {
            YamlConfiguration configuration = new YamlConfiguration();
            this.persistentData.forEach((arg_0, arg_1) -> ((YamlConfiguration)configuration).set(arg_0, arg_1));
            try {
                configuration.save(this.getFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.needsSaving = false;
        }
    }

    private void checkIfPlayerChanged(Player player) {
        if (this.lastLogin != player.getLastLogin()) {
            this.lastLogin = player.getLastLogin();
            this.data.clear();
        }
    }

    public String getData(Player player, String key) {
        this.checkIfPlayerChanged(player);
        return this.data.get(key);
    }

    public void setData(Player player, String key, String value) {
        this.checkIfPlayerChanged(player);
        this.data.put(key, value);
    }

    public String getPersistentData(String key) {
        return this.persistentData.get(key);
    }

    public void setPersistentData(String key, String value) {
        this.persistentData.put(key, value);
        this.needsSaving = true;
        if (this.saveFuture == null || this.saveFuture.isDone() || this.saveFuture.isCancelled()) {
            this.saveFuture = this.scheduler.schedule(this::save, 60L, TimeUnit.SECONDS);
        }
    }
}

