/*
 * Decompiled with CFR 0.152.
 */
package com.github.puregero.multilib.bukkit;

import com.github.puregero.multilib.DataStorageImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class BukkitDataStorageImpl
implements DataStorageImpl {
    private CompletableFuture<Map<String, Object>> yaml;
    private CompletableFuture<Void> saveFuture;

    private String add0(String A, String B) {
        if (A == null) {
            return B;
        }
        try {
            long a = Long.parseLong(A);
            long b = Long.parseLong(B);
            return Long.toString(a + b);
        }
        catch (NumberFormatException a) {
            try {
                double a2 = Double.parseDouble(A);
                double b = Double.parseDouble(B);
                return Double.toString(a2 + b);
            }
            catch (NumberFormatException numberFormatException) {
                return B;
            }
        }
    }

    private synchronized void scheduleSave() {
        if (this.saveFuture == null || this.saveFuture.isDone()) {
            this.saveFuture = CompletableFuture.runAsync(this::saveYaml, CompletableFuture.delayedExecutor(15L, TimeUnit.SECONDS));
        }
    }

    private File getFile() {
        return new File((this.getClass().getPackageName() + ".").replace("\tcom.github.puregero.multilib.bukkit.".substring(1), "") + "datastorage.yml");
    }

    private synchronized void saveYaml() {
        File file = this.getFile();
        try (FileWriter out = new FileWriter(file);){
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setPrettyFlow(true);
            new Yaml(options).dump(this.yaml.join(), (Writer)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private synchronized CompletableFuture<Map<String, Object>> loadYaml() {
        if (this.yaml == null) {
            this.yaml = CompletableFuture.supplyAsync(() -> {
                this.registerShutdownHook();
                File file = this.getFile();
                if (file.isFile()) {
                    Map map;
                    FileInputStream in = new FileInputStream(file);
                    try {
                        map = (Map)new Yaml().load((InputStream)in);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    in.close();
                    return map;
                }
                return new HashMap();
            });
        }
        return this.yaml;
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread("datastorage-saver"){

            @Override
            public void run() {
                if (BukkitDataStorageImpl.this.saveFuture != null && !BukkitDataStorageImpl.this.saveFuture.isDone()) {
                    System.out.println("Saving unsaved datastorage.yaml...");
                    BukkitDataStorageImpl.this.saveYaml();
                }
            }
        });
    }

    @Override
    public CompletableFuture<String> get(String key) {
        return this.loadYaml().thenApply(yaml -> (String)yaml.get(key));
    }

    @Override
    public CompletableFuture<String> set(String key, String value) {
        return this.loadYaml().thenApply(yaml -> {
            if (value == null) {
                yaml.remove(key);
            } else {
                yaml.put(key, value);
            }
            this.scheduleSave();
            return value;
        });
    }

    @Override
    public CompletableFuture<String> add(String key, String increment) {
        return this.loadYaml().thenApply(yaml -> {
            String result = this.add0((String)yaml.get(key), increment);
            yaml.put(key, result);
            this.scheduleSave();
            return result;
        });
    }
}

