/*
 * Decompiled with CFR 0.152.
 */
package com.github.puregero.multilib.multipaper;

import com.github.puregero.multilib.DataStorageImpl;
import com.github.puregero.multilib.MultiLibImpl;
import com.github.puregero.multilib.multipaper.MultiPaperDataStorageImpl;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MultiPaperImpl
implements MultiLibImpl {
    private final MultiPaperDataStorageImpl dataStorage = new MultiPaperDataStorageImpl(this);

    public MultiPaperImpl() {
        try {
            Player.class.getMethod("isExternalPlayer", new Class[0]);
        }
        catch (NoSuchMethodError | NoSuchMethodException e) {
            throw new IllegalStateException("Not a MultiPaper environment", e);
        }
    }

    public boolean isChunkExternal(World world, int cx, int cz) {
        return world.isChunkExternal(cx, cz);
    }

    public boolean isChunkExternal(Location location) {
        return location.isChunkExternal();
    }

    public boolean isChunkExternal(Entity entity) {
        return entity.isInExternalChunk();
    }

    public boolean isChunkExternal(Block block) {
        return block.isInExternalChunk();
    }

    public boolean isChunkExternal(Chunk chunk) {
        return chunk.isExternalChunk();
    }

    public boolean isChunkLocal(World world, int cx, int cz) {
        return world.isChunkLocal(cx, cz);
    }

    public boolean isChunkLocal(Location location) {
        return location.isChunkLocal();
    }

    public boolean isChunkLocal(Entity entity) {
        return entity.isInLocalChunk();
    }

    public boolean isChunkLocal(Block block) {
        return block.isInLocalChunk();
    }

    public boolean isChunkLocal(Chunk chunk) {
        return chunk.isLocalChunk();
    }

    public boolean isExternalPlayer(Player player) {
        return player.isExternalPlayer();
    }

    public boolean isLocalPlayer(Player player) {
        return player.isLocalPlayer();
    }

    @NotNull
    public String getLocalServerName() {
        return Bukkit.getLocalServerName();
    }

    public String getExternalServerName(Player player) {
        return player.getExternalServerName();
    }

    public String getData(Player player, String key) {
        return player.getData(key);
    }

    public void setData(Player player, String key, String value) {
        player.setData(key, value);
    }

    public String getPersistentData(Player player, String key) {
        return player.getPersistentData(key);
    }

    public void setPersistentData(Player player, String key, String value) {
        player.setPersistentData(key, value);
    }

    public void on(Plugin plugin, String channel, Consumer<byte[]> callback) {
        Bukkit.getMultiPaperNotificationManager().on(plugin, channel, callback);
    }

    public void onString(Plugin plugin, String channel, Consumer<String> callback) {
        Bukkit.getMultiPaperNotificationManager().onString(plugin, channel, callback);
    }

    public void on(Plugin plugin, String channel, BiConsumer<byte[], BiConsumer<String, byte[]>> callbackWithReply) {
        Bukkit.getMultiPaperNotificationManager().on(plugin, channel, callbackWithReply);
    }

    public void onString(Plugin plugin, String channel, BiConsumer<String, BiConsumer<String, String>> callbackWithReply) {
        Bukkit.getMultiPaperNotificationManager().onString(plugin, channel, callbackWithReply);
    }

    public void notify(String channel, byte[] data) {
        Bukkit.getMultiPaperNotificationManager().notify(channel, data);
    }

    public void notify(String channel, String data) {
        Bukkit.getMultiPaperNotificationManager().notify(channel, data);
    }

    public void notify(Chunk chunk, String channel, byte[] data) {
        Bukkit.getMultiPaperNotificationManager().notify(chunk, channel, data);
    }

    public void notify(Chunk chunk, String channel, String data) {
        Bukkit.getMultiPaperNotificationManager().notify(chunk, channel, data);
    }

    public void notifyOwningServer(Chunk chunk, String channel, byte[] data) {
        Bukkit.getMultiPaperNotificationManager().notifyOwningServer(chunk, channel, data);
    }

    public void notifyOwningServer(Chunk chunk, String channel, String data) {
        Bukkit.getMultiPaperNotificationManager().notifyOwningServer(chunk, channel, data);
    }

    public void notifyOwningServer(Player player, String channel, byte[] data) {
        Bukkit.getMultiPaperNotificationManager().notifyOwningServer(player, channel, data);
    }

    public void notifyOwningServer(Player player, String channel, String data) {
        Bukkit.getMultiPaperNotificationManager().notifyOwningServer(player, channel, data);
    }

    public void chatOnOtherServers(Player player, String message) {
        player.chatOnOtherServers(message);
    }

    public Collection<? extends Player> getAllOnlinePlayers() {
        return Bukkit.getAllOnlinePlayers();
    }

    public Collection<? extends Player> getLocalOnlinePlayers() {
        return Bukkit.getLocalOnlinePlayers();
    }

    public DataStorageImpl getDataStorage() {
        return this.dataStorage;
    }
}

