/*
 * Decompiled with CFR 0.152.
 */
package com.github.puregero.multilib.bukkit;

import com.github.puregero.multilib.DataStorageImpl;
import com.github.puregero.multilib.MultiLibImpl;
import com.github.puregero.multilib.bukkit.BukkitImpl;
import com.github.puregero.multilib.util.StringAddition;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class BukkitDataStorageImpl
implements DataStorageImpl {
    private final BukkitImpl multilib;
    private CompletableFuture<Map<String, Object>> yaml;
    private CompletableFuture<Void> saveFuture;

    public BukkitDataStorageImpl(BukkitImpl multilib) {
        this.multilib = multilib;
    }

    private synchronized void scheduleSave() {
        if (this.saveFuture == null || this.saveFuture.isDone()) {
            this.saveFuture = CompletableFuture.runAsync(this::saveYaml, CompletableFuture.delayedExecutor(15L, TimeUnit.SECONDS));
        }
    }

    private File getFile() {
        return new File((this.getClass().getPackageName() + ".").replace("\tcom.github.puregero.multilib.bukkit.".substring(1), "") + "datastorage.yml");
    }

    private synchronized void saveYaml() {
        File file = this.getFile();
        try (FileWriter out = new FileWriter(file);){
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setPrettyFlow(true);
            new Yaml(options).dump(this.yaml.join(), (Writer)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private synchronized CompletableFuture<Map<String, Object>> loadYaml() {
        if (this.yaml == null) {
            this.yaml = CompletableFuture.supplyAsync(() -> {
                this.registerShutdownHook();
                File file = this.getFile();
                if (file.isFile()) {
                    Map map;
                    FileInputStream in = new FileInputStream(file);
                    try {
                        map = (Map)new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load((InputStream)in);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    in.close();
                    return map;
                }
                return new HashMap();
            });
        }
        return this.yaml;
    }

    private void registerShutdownHook() {
        final JavaPlugin plugin = JavaPlugin.getProvidingPlugin(this.getClass());
        plugin.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onDisable(PluginDisableEvent event) {
                if (event.getPlugin() == plugin && BukkitDataStorageImpl.this.saveFuture != null && !BukkitDataStorageImpl.this.saveFuture.isDone()) {
                    System.out.println("Saving unsaved datastorage.yaml...");
                    BukkitDataStorageImpl.this.saveYaml();
                }
            }
        }, (Plugin)plugin);
    }

    public CompletableFuture<String> get(String key) {
        return this.loadYaml().thenApply(yaml -> (String)yaml.get(key));
    }

    public CompletableFuture<Map<String, String>> list(String keyPrefix) {
        return this.loadYaml().thenApply(yaml -> {
            HashMap<String, String> list = new HashMap<String, String>();
            for (Map.Entry entry : yaml.entrySet()) {
                Object patt0$temp;
                if (entry.getKey() == null || !((String)entry.getKey()).startsWith(keyPrefix) || !((patt0$temp = entry.getValue()) instanceof String)) continue;
                String string = (String)patt0$temp;
                list.put((String)entry.getKey(), string);
            }
            return list;
        });
    }

    public CompletableFuture<String> set(String key, String value) {
        return this.loadYaml().thenApply(yaml -> {
            if (value == null) {
                yaml.remove(key);
            } else {
                yaml.put(key, value);
            }
            this.scheduleSave();
            return value;
        });
    }

    public CompletableFuture<String> add(String key, String increment) {
        return this.loadYaml().thenApply(yaml -> {
            String result = StringAddition.add((String)((String)yaml.get(key)), (String)increment);
            yaml.put(key, result);
            this.scheduleSave();
            return result;
        });
    }

    public MultiLibImpl getMultiLib() {
        return this.multilib;
    }
}

