/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.contrib.cassandra.spout;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichSpout;
import backtype.storm.tuple.Fields;
import java.util.Iterator;
import java.util.Map;
import me.prettyprint.cassandra.model.QuorumAllConsistencyLevelPolicy;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.RangeSlicesQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CassandraBaseSpout
extends BaseRichSpout {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraBaseSpout.class);
    public static String CASSANDRA_HOST = "cassandra.host";
    public static final String CASSANDRA_KEYSPACE = "cassandra.keyspace";
    public static final String CASSANDRA_BATCH_MAX_SIZE = "cassandra.batch.max_size";
    public static String CASSANDRA_CLIENT_CLASS = "cassandra.client.class";
    private SpoutOutputCollector _collector;
    private Cluster cluster = null;
    private Keyspace keyspace = null;

    public void open(Map stormConf, TopologyContext topologyContext, SpoutOutputCollector spoutOutputCollector) {
        this._collector = spoutOutputCollector;
        this.cluster = HFactory.getOrCreateCluster((String)"Test Cluster", (String)"localhost");
        this.keyspace = HFactory.createKeyspace((String)"storm_poc", (Cluster)this.cluster, (ConsistencyLevelPolicy)new QuorumAllConsistencyLevelPolicy());
    }

    public void nextTuple() {
        OrderedRows rows;
        int row_count = 100;
        RangeSlicesQuery rangeSlicesQuery = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)LongSerializer.get()).setColumnFamily("call_log_timeline").setRange(null, null, false, 10).setRowCount(row_count);
        String last_key = "";
        do {
            rangeSlicesQuery.setKeys((Object)last_key, null);
            LOG.info("> " + last_key);
            QueryResult result = rangeSlicesQuery.execute();
            rows = (OrderedRows)result.get();
            Iterator rowsIterator = rows.iterator();
            if (!last_key.equals("") && rowsIterator != null) {
                rowsIterator.next();
            }
            while (rowsIterator.hasNext()) {
                Row row = (Row)rowsIterator.next();
                last_key = (String)row.getKey();
                if (row.getColumnSlice().getColumns().isEmpty()) continue;
                LOG.info((String)row.getKey());
            }
        } while (rows.getCount() >= row_count);
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            LOG.warn(e.getMessage());
        }
    }

    public void close() {
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields(new String[]{"TL", "sort_col", "UUID"}));
    }
}

