/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.contrib.cassandra.bolt.mapper;

import backtype.storm.contrib.cassandra.bolt.mapper.ColumnsMapper;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DelimitedColumnsMapper
implements ColumnsMapper,
Serializable {
    private String columnKeyField;
    private String emitIdFieldName;
    private String emitValueFieldName;
    private String delimiter;
    private boolean isDrpc;

    public DelimitedColumnsMapper(String columnKeyField, String delimiter, String emitIdFieldName, String emitValueFieldName, boolean isDrpc) {
        this.columnKeyField = columnKeyField;
        this.delimiter = delimiter;
        this.isDrpc = isDrpc;
        this.emitIdFieldName = emitIdFieldName;
        this.emitValueFieldName = emitValueFieldName;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        if (this.isDrpc) {
            declarer.declare(new Fields(new String[]{"id", this.emitIdFieldName, this.emitValueFieldName}));
        } else {
            declarer.declare(new Fields(new String[]{this.emitIdFieldName, this.emitValueFieldName}));
        }
    }

    @Override
    public List<Values> mapToValues(String rowKey, Map<String, String> columns, Tuple input) {
        ArrayList<Values> values = new ArrayList<Values>();
        String delimVal = columns.get(this.columnKeyField);
        if (delimVal != null) {
            String[] vals;
            for (String val : vals = delimVal.split(this.delimiter)) {
                if (this.isDrpc) {
                    values.add(new Values(new Object[]{input.getValue(0), rowKey, val}));
                    continue;
                }
                values.add(new Values(new Object[]{rowKey, val}));
            }
        }
        return values;
    }
}

