/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.contrib.cassandra.bolt.mapper;

import backtype.storm.contrib.cassandra.bolt.mapper.TupleMapper;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import java.util.HashMap;
import java.util.Map;

public class DefaultTupleMapper
implements TupleMapper {
    private static final long serialVersionUID = 1L;
    private String rowKeyField;
    private String columnFamily;

    public DefaultTupleMapper(String columnFamily, String rowKeyField) {
        this.rowKeyField = rowKeyField;
        this.columnFamily = columnFamily;
    }

    @Override
    public String mapToRowKey(Tuple tuple) {
        return tuple.getValueByField(this.rowKeyField).toString();
    }

    @Override
    public Map<String, String> mapToColumns(Tuple tuple) {
        Fields fields = tuple.getFields();
        HashMap<String, String> columns = new HashMap<String, String>();
        for (int i = 0; i < fields.size(); ++i) {
            String name;
            Object value = tuple.getValueByField(name = fields.get(i));
            columns.put(name, value != null ? value.toString() : "");
        }
        return columns;
    }

    @Override
    public String mapToColumnFamily(Tuple tuple) {
        return this.columnFamily;
    }
}

