/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.contrib.cassandra.bolt;

import backtype.storm.contrib.cassandra.bolt.CassandraBatchingBolt;
import backtype.storm.contrib.cassandra.bolt.mapper.TupleMapper;
import backtype.storm.coordination.BatchOutputCollector;
import backtype.storm.coordination.IBatchBolt;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Tuple;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalCassandraBatchBolt
extends CassandraBatchingBolt
implements IBatchBolt {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionalCassandraBatchBolt.class);
    private Object transactionId = null;

    public TransactionalCassandraBatchBolt(TupleMapper tupleMapper) {
        super(tupleMapper);
    }

    public void prepare(Map conf, TopologyContext context, BatchOutputCollector collector, Object id) {
        super.prepare(conf, context);
        this.queue = new LinkedBlockingQueue();
        this.transactionId = id;
        LOG.debug("Preparing cassandra batch [" + this.transactionId + "]");
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }

    @Override
    public void execute(Tuple tuple) {
        this.queue.add(tuple);
    }

    public void finishBatch() {
        ArrayList<Tuple> batch = new ArrayList<Tuple>();
        int size = this.queue.drainTo(batch);
        LOG.debug("Finishing batch for [" + this.transactionId + "], writing [" + size + "] tuples.");
        try {
            this.writeTuples(batch);
        }
        catch (Exception e) {
            LOG.error("Could not write batch to cassandra.", (Throwable)e);
        }
    }
}

