/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.contrib.cassandra.bolt;

import backtype.storm.contrib.cassandra.bolt.AbstractBatchingBolt;
import backtype.storm.contrib.cassandra.bolt.AckStrategy;
import backtype.storm.contrib.cassandra.bolt.mapper.DefaultTupleMapper;
import backtype.storm.contrib.cassandra.bolt.mapper.TupleMapper;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Tuple;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraBatchingBolt
extends AbstractBatchingBolt {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraBatchingBolt.class);

    public CassandraBatchingBolt(TupleMapper tupleMapper) {
        super(tupleMapper);
    }

    public CassandraBatchingBolt(String columnFamily, String rowKeyField) {
        this(new DefaultTupleMapper(columnFamily, rowKeyField));
    }

    @Override
    public void executeBatch(List<Tuple> inputs) {
        block4: {
            try {
                this.writeTuples(inputs);
                if (this.ackStrategy != AckStrategy.ACK_ON_WRITE) break block4;
                for (Tuple tupleToAck : inputs) {
                    this.collector.ack(tupleToAck);
                }
            }
            catch (Throwable e) {
                LOG.error("Unable to write batch.", e);
                for (Tuple tupleToAck : inputs) {
                    this.collector.fail(tupleToAck);
                }
            }
        }
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return null;
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

