/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.contrib.cassandra;

import java.util.Iterator;
import java.util.List;
import me.prettyprint.cassandra.model.QuorumAllConsistencyLevelPolicy;
import me.prettyprint.cassandra.serializers.CompositeSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.Composite;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.RangeSlicesQuery;

public class Dumper {
    private final Cluster cluster = HFactory.getOrCreateCluster((String)"Test Cluster", (String)"localhost");
    private final Keyspace keyspace = HFactory.createKeyspace((String)"storm_poc", (Cluster)this.cluster, (ConsistencyLevelPolicy)new QuorumAllConsistencyLevelPolicy());

    public void run() {
        OrderedRows rows;
        int row_count = 100;
        RangeSlicesQuery rangeSlicesQuery = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)StringSerializer.get(), (Serializer)CompositeSerializer.get(), (Serializer)UUIDSerializer.get()).setColumnFamily("call_log_timeline").setRange(null, null, false, 10).setRowCount(row_count);
        String last_key = "";
        do {
            rangeSlicesQuery.setKeys((Object)last_key, null);
            System.out.println(" > " + last_key);
            QueryResult result = rangeSlicesQuery.execute();
            rows = (OrderedRows)result.get();
            Iterator rowsIterator = rows.iterator();
            if (!last_key.equals("") && rowsIterator != null) {
                rowsIterator.next();
            }
            while (rowsIterator.hasNext()) {
                Row row = (Row)rowsIterator.next();
                last_key = (String)row.getKey();
                if (row.getColumnSlice().getColumns().isEmpty()) continue;
                System.out.println("key : " + last_key);
                List columns = row.getColumnSlice().getColumns();
                for (HColumn col : columns) {
                    System.out.println(" col name: " + ((Composite)col.getName()).get(0, (Serializer)LongSerializer.get()) + ":" + (String)((Composite)col.getName()).get(1, (Serializer)StringSerializer.get()) + " value: " + col.getValue());
                }
            }
        } while (rows.getCount() >= row_count);
    }

    public static void main(String[] args) {
        new Dumper().run();
    }
}

