/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.contrib.cassandra.client;

import backtype.storm.contrib.cassandra.bolt.mapper.TupleMapper;
import backtype.storm.contrib.cassandra.client.CassandraClient;
import backtype.storm.tuple.Tuple;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.AstyanaxTypeFactory;
import com.netflix.astyanax.Cluster;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.NodeDiscoveryType;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.astyanax.connectionpool.impl.CountingConnectionPoolMonitor;
import com.netflix.astyanax.impl.AstyanaxConfigurationImpl;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.thrift.ThriftFamilyFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstyanaxClient
implements CassandraClient {
    private static final Logger LOG = LoggerFactory.getLogger(AstyanaxClient.class);
    private AstyanaxContext<Keyspace> astyanaxContext;
    protected Cluster cluster;
    protected Keyspace keyspace;

    @Override
    public void start(String cassandraHost, String cassandraKeyspace) {
        try {
            this.astyanaxContext = new AstyanaxContext.Builder().forCluster("ClusterName").forKeyspace(cassandraKeyspace).withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl().setDiscoveryType(NodeDiscoveryType.NONE)).withConnectionPoolConfiguration((ConnectionPoolConfiguration)new ConnectionPoolConfigurationImpl("MyConnectionPool").setMaxConnsPerHost(1).setSeeds(cassandraHost)).withConnectionPoolMonitor((ConnectionPoolMonitor)new CountingConnectionPoolMonitor()).buildKeyspace((AstyanaxTypeFactory)ThriftFamilyFactory.getInstance());
            this.astyanaxContext.start();
            this.keyspace = (Keyspace)this.astyanaxContext.getEntity();
            this.keyspace.describeKeyspace();
        }
        catch (Throwable e) {
            LOG.warn("Astyanax initialization failed.", e);
            throw new IllegalStateException("Failed to prepare Astyanax", e);
        }
    }

    @Override
    public void stop() {
        this.astyanaxContext.shutdown();
    }

    @Override
    public Map<String, String> lookup(String columnFamilyName, String rowKey) throws Exception {
        HashMap<String, String> colMap = new HashMap<String, String>();
        ColumnFamily columnFamily = new ColumnFamily(columnFamilyName, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        OperationResult result = this.keyspace.prepareQuery(columnFamily).getKey((Object)rowKey).execute();
        ColumnList columns = (ColumnList)result.getResult();
        for (Column column : columns) {
            colMap.put((String)column.getName(), column.getStringValue());
        }
        return colMap;
    }

    @Override
    public void writeTuple(Tuple input, TupleMapper tupleMapper) throws Exception {
        String columnFamilyName = tupleMapper.mapToColumnFamily(input);
        String rowKey = tupleMapper.mapToRowKey(input);
        MutationBatch mutation = this.keyspace.prepareMutationBatch();
        ColumnFamily columnFamily = new ColumnFamily(columnFamilyName, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        this.addTupleToMutation(input, (ColumnFamily<String, String>)columnFamily, rowKey, mutation, tupleMapper);
        mutation.execute();
    }

    @Override
    public void writeTuples(List<Tuple> inputs, TupleMapper tupleMapper) throws Exception {
        MutationBatch mutation = this.keyspace.prepareMutationBatch();
        for (Tuple input : inputs) {
            String columnFamilyName = tupleMapper.mapToColumnFamily(input);
            String rowKey = tupleMapper.mapToRowKey(input);
            ColumnFamily columnFamily = new ColumnFamily(columnFamilyName, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
            this.addTupleToMutation(input, (ColumnFamily<String, String>)columnFamily, rowKey, mutation, tupleMapper);
        }
        mutation.execute();
    }

    private void addTupleToMutation(Tuple input, ColumnFamily<String, String> columnFamily, String rowKey, MutationBatch mutation, TupleMapper tupleMapper) {
        Map<String, String> columns = tupleMapper.mapToColumns(input);
        for (Map.Entry<String, String> entry : columns.entrySet()) {
            mutation.withRow(columnFamily, (Object)rowKey).putColumn((Object)entry.getKey(), entry.getValue(), null);
        }
    }
}

