/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.contrib.cassandra.bolt;

import backtype.storm.contrib.cassandra.bolt.BaseCassandraBolt;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.BasicOutputCollector;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.cassandra.service.template.ThriftColumnFamilyTemplate;
import me.prettyprint.hector.api.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueLessColumnLookupBolt
extends BaseCassandraBolt {
    private static final Logger LOG = LoggerFactory.getLogger(ValueLessColumnLookupBolt.class);
    private String columnFamily;
    private String rowKeyField;
    private String emitIdFieldName;
    private String emitValueFieldName;
    private boolean isDrpc = false;

    public ValueLessColumnLookupBolt(String columnFamily, String rowKeyField, String emitIdFieldName, String emitValueFieldName, boolean isDrpc) {
        this.columnFamily = columnFamily;
        this.rowKeyField = rowKeyField;
        this.emitIdFieldName = emitIdFieldName;
        this.emitValueFieldName = emitValueFieldName;
        this.isDrpc = isDrpc;
    }

    public ValueLessColumnLookupBolt(String columnFamily, String rowKeyField, String columnKeyField, String delimiter, String emitIdFieldName, String emitValueFieldName) {
        this(columnFamily, rowKeyField, emitIdFieldName, emitValueFieldName, false);
    }

    @Override
    public void prepare(Map stormConf, TopologyContext context) {
        super.prepare(stormConf, context);
    }

    public void execute(Tuple input, BasicOutputCollector collector) {
        String rowKey = input.getStringByField(this.rowKeyField);
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, this.columnFamily, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        ColumnFamilyResult result = template.queryColumns((Object)rowKey);
        for (String val : result.getColumnNames()) {
            if (this.isDrpc) {
                collector.emit((List)new Values(new Object[]{input.getValue(0), rowKey, val}));
                continue;
            }
            collector.emit((List)new Values(new Object[]{rowKey, val}));
        }
    }

    public void cleanup() {
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        if (this.isDrpc) {
            declarer.declare(new Fields(new String[]{"id", this.emitIdFieldName, this.emitValueFieldName}));
        } else {
            declarer.declare(new Fields(new String[]{this.emitIdFieldName, this.emitValueFieldName}));
        }
    }

    public Map<String, Object> getComponentConfiguration() {
        return null;
    }
}

