/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.contrib.cassandra.client;

import backtype.storm.contrib.cassandra.bolt.mapper.TupleMapper;
import backtype.storm.contrib.cassandra.client.CassandraClient;
import backtype.storm.tuple.Tuple;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.cassandra.service.template.ThriftColumnFamilyTemplate;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;

public class HectorClient
implements CassandraClient {
    private Cluster cluster;
    private Keyspace keyspace;

    @Override
    public void start(String cassandraHost, String cassandraKeyspace) {
        CassandraHostConfigurator chc = new CassandraHostConfigurator(cassandraHost);
        chc.setAutoDiscoverHosts(true);
        chc.setRunAutoDiscoveryAtStartup(false);
        this.cluster = HFactory.getOrCreateCluster((String)"cirrus-cluster", (CassandraHostConfigurator)chc);
        this.keyspace = HFactory.createKeyspace((String)cassandraKeyspace, (Cluster)this.cluster);
    }

    @Override
    public void stop() {
        this.cluster.getConnectionManager().shutdown();
    }

    @Override
    public Map<String, String> lookup(String columnFamilyName, String rowKey) throws Exception {
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, columnFamilyName, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        ColumnFamilyResult result = template.queryColumns((Object)rowKey);
        HashMap<String, String> colMap = new HashMap<String, String>();
        Collection cols = result.getColumnNames();
        for (String colName : cols) {
            colMap.put(colName, result.getString((Object)colName));
        }
        return colMap;
    }

    @Override
    public void writeTuple(Tuple input, TupleMapper tupleMapper) throws Exception {
        String rowKey = tupleMapper.mapToRowKey(input);
        Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)new StringSerializer());
        this.addTupleToMutation(input, rowKey, (Mutator<String>)mutator, tupleMapper);
        mutator.execute();
    }

    private void addTupleToMutation(Tuple input, String rowKey, Mutator<String> mutator, TupleMapper tupleMapper) {
        Map<String, String> columns = tupleMapper.mapToColumns(input);
        for (Map.Entry<String, String> entry : columns.entrySet()) {
            mutator.addInsertion((Object)rowKey, tupleMapper.mapToColumnFamily(input), HFactory.createStringColumn((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    @Override
    public void writeTuples(List<Tuple> inputs, TupleMapper tupleMapper) throws Exception {
        Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)new StringSerializer());
        for (Tuple input : inputs) {
            String rowKey = tupleMapper.mapToRowKey(input);
            this.addTupleToMutation(input, rowKey, (Mutator<String>)mutator, tupleMapper);
        }
        mutator.execute();
    }
}

