/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.contrib.cassandra.bolt.mapper;

import backtype.storm.contrib.cassandra.bolt.mapper.ColumnsMapper;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ValuelessColumnsMapper
implements ColumnsMapper,
Serializable {
    private String emitFieldForRowKey;
    private String emitFieldForColumnName;
    private boolean isDrpc;

    public ValuelessColumnsMapper(String emitFieldForRowKey, String emitFieldForColumnName, boolean isDrpc) {
        this.isDrpc = isDrpc;
        this.emitFieldForRowKey = emitFieldForRowKey;
        this.emitFieldForColumnName = emitFieldForColumnName;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        if (this.isDrpc) {
            declarer.declare(new Fields(new String[]{"id", this.emitFieldForRowKey, this.emitFieldForColumnName}));
        } else {
            declarer.declare(new Fields(new String[]{this.emitFieldForRowKey, this.emitFieldForColumnName}));
        }
    }

    @Override
    public List<Values> mapToValues(String rowKey, Map<String, String> columns, Tuple input) {
        ArrayList<Values> values = new ArrayList<Values>();
        for (String col : columns.keySet()) {
            if (this.isDrpc) {
                values.add(new Values(new Object[]{input.getValue(0), rowKey, col}));
                continue;
            }
            values.add(new Values(new Object[]{rowKey, col}));
        }
        return values;
    }
}

