/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.contrib.cassandra.bolt;

import backtype.storm.contrib.cassandra.bolt.BatchingCassandraBolt;
import backtype.storm.contrib.cassandra.bolt.CassandraConstants;
import backtype.storm.contrib.cassandra.bolt.determinable.ColumnFamilyDeterminable;
import backtype.storm.contrib.cassandra.bolt.determinable.DefaultColumnFamilyDeterminable;
import backtype.storm.contrib.cassandra.bolt.determinable.DefaultRowKeyDeterminable;
import backtype.storm.contrib.cassandra.bolt.determinable.RowKeyDeterminable;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBatchingCassandraBolt
extends BatchingCassandraBolt
implements CassandraConstants {
    private RowKeyDeterminable rkDeterminable;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBatchingCassandraBolt.class);

    public DefaultBatchingCassandraBolt(ColumnFamilyDeterminable cfDeterminable, RowKeyDeterminable rkDeterminable) {
        super(cfDeterminable);
        this.rkDeterminable = rkDeterminable;
    }

    public DefaultBatchingCassandraBolt(String columnFamily, String rowKey) {
        this(new DefaultColumnFamilyDeterminable(columnFamily), new DefaultRowKeyDeterminable(rowKey));
    }

    @Override
    public void executeBatch(List<Tuple> inputs) {
        block6: {
            ArrayList<Tuple> tuplesToAck = new ArrayList<Tuple>();
            try {
                Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)new StringSerializer());
                for (Tuple input : inputs) {
                    String columnFamily = this.cfDeterminable.determineColumnFamily(input);
                    Object rowKey = this.rkDeterminable.determineRowKey(input);
                    Fields fields = input.getFields();
                    for (int i = 0; i < fields.size(); ++i) {
                        mutator.addInsertion((Object)rowKey.toString(), columnFamily, HFactory.createStringColumn((String)fields.get(i), (String)input.getValue(i).toString()));
                    }
                    tuplesToAck.add(input);
                }
                mutator.execute();
                if (this.ackStrategy != BatchingCassandraBolt.AckStrategy.ACK_ON_WRITE) break block6;
                for (Tuple tupleToAck : tuplesToAck) {
                    this.collector.ack(tupleToAck);
                }
            }
            catch (Throwable e) {
                LOG.warn("Unable to write batch.", e);
                if (this.ackStrategy != BatchingCassandraBolt.AckStrategy.ACK_ON_WRITE) break block6;
                for (Tuple tupleToAck : tuplesToAck) {
                    this.collector.fail(tupleToAck);
                }
            }
        }
    }

    public Map<String, Object> getComponentConfiguration() {
        return null;
    }
}

