/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.contrib.cassandra.bolt;

import backtype.storm.contrib.cassandra.bolt.CassandraConstants;
import backtype.storm.contrib.cassandra.bolt.determinable.ColumnFamilyDeterminable;
import backtype.storm.contrib.cassandra.bolt.determinable.DefaultColumnFamilyDeterminable;
import backtype.storm.contrib.cassandra.bolt.determinable.DefaultRowKeyDeterminable;
import backtype.storm.contrib.cassandra.bolt.determinable.RowKeyDeterminable;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import java.util.Map;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraBolt
implements IRichBolt,
CassandraConstants {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraBolt.class);
    private OutputCollector collector;
    private boolean autoAck = true;
    private Fields declaredFields;
    private String cassandraHost;
    private String cassandraKeyspace;
    private Cluster cluster;
    private Keyspace keyspace;
    private ColumnFamilyDeterminable cfDeterminable;
    private RowKeyDeterminable rkDeterminable;

    public CassandraBolt(String columnFamily, String rowkeyField) {
        this(new DefaultColumnFamilyDeterminable(columnFamily), new DefaultRowKeyDeterminable(rowkeyField));
    }

    public CassandraBolt(ColumnFamilyDeterminable cfDeterminable, RowKeyDeterminable rkDeterminable) {
        this.cfDeterminable = cfDeterminable;
        this.rkDeterminable = rkDeterminable;
    }

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        LOG.debug("Preparing...");
        this.cassandraHost = (String)stormConf.get("cassandra.host");
        this.cassandraKeyspace = (String)stormConf.get("cassandra.keyspace");
        this.collector = collector;
        this.initCassandraConnection();
    }

    private void initCassandraConnection() {
        try {
            this.cluster = HFactory.getOrCreateCluster((String)"cassandra-bolt", (CassandraHostConfigurator)new CassandraHostConfigurator(this.cassandraHost));
            this.keyspace = HFactory.createKeyspace((String)this.cassandraKeyspace, (Cluster)this.cluster);
        }
        catch (Throwable e) {
            LOG.warn("Preparation failed.", e);
            throw new IllegalStateException("Failed to prepare CassandraBolt", e);
        }
    }

    public void execute(Tuple input) {
        LOG.debug("Tuple received: " + input);
        try {
            String columnFamily = this.cfDeterminable.determineColumnFamily(input);
            Object rowKey = this.rkDeterminable.determineRowKey(input);
            Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)new StringSerializer());
            Fields fields = input.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                mutator.addInsertion((Object)rowKey.toString(), columnFamily, HFactory.createStringColumn((String)fields.get(i), (String)input.getValue(i).toString()));
            }
            mutator.execute();
            if (this.autoAck) {
                this.collector.ack(input);
            }
        }
        catch (Throwable e) {
            LOG.warn("Caught throwable.", e);
        }
    }

    public void cleanup() {
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        if (this.declaredFields != null) {
            declarer.declare(this.declaredFields);
        }
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }

    public Map<String, Object> getComponentConfiguration() {
        return null;
    }
}

