/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.contrib.cassandra.bolt;

import backtype.storm.contrib.cassandra.bolt.CassandraConstants;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.IBasicBolt;
import java.util.Map;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.factory.HFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCassandraBolt
implements IBasicBolt,
CassandraConstants {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCassandraBolt.class);
    private String cassandraHost;
    private String cassandraKeyspace;
    protected Cluster cluster;
    protected Keyspace keyspace;

    public void prepare(Map stormConf, TopologyContext context) {
        this.cassandraHost = (String)stormConf.get("cassandra.host");
        this.cassandraKeyspace = (String)stormConf.get("cassandra.keyspace");
        this.initCassandraConnection();
    }

    private void initCassandraConnection() {
        try {
            this.cluster = HFactory.getOrCreateCluster((String)"cassandra-bolt", (CassandraHostConfigurator)new CassandraHostConfigurator(this.cassandraHost));
            this.keyspace = HFactory.createKeyspace((String)this.cassandraKeyspace, (Cluster)this.cluster);
        }
        catch (Throwable e) {
            LOG.warn("Preparation failed.", e);
            throw new IllegalStateException("Failed to prepare CassandraBolt", e);
        }
    }
}

