/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.regression;

import com.github.pmerienne.trident.ml.core.Instance;
import com.github.pmerienne.trident.ml.regression.Regressor;
import com.github.pmerienne.trident.ml.util.KeysUtil;
import java.util.Arrays;
import java.util.List;
import storm.trident.operation.TridentCollector;
import storm.trident.state.BaseStateUpdater;
import storm.trident.state.map.MapState;
import storm.trident.tuple.TridentTuple;

public class RegressionUpdater
extends BaseStateUpdater<MapState<Regressor>> {
    private static final long serialVersionUID = -4860370637415723032L;
    private String classifierName;
    private Regressor initialRegressor;

    public RegressionUpdater(String classifierName, Regressor initialRegressor) {
        this.classifierName = classifierName;
        this.initialRegressor = initialRegressor;
    }

    public void updateState(MapState<Regressor> state, List<TridentTuple> tuples, TridentCollector collector) {
        List regressors = state.multiGet(KeysUtil.toKeys(this.classifierName));
        Regressor regressor = null;
        if (regressors != null && !regressors.isEmpty()) {
            regressor = (Regressor)regressors.get(0);
        }
        if (regressor == null) {
            regressor = this.initialRegressor;
        }
        for (TridentTuple tuple : tuples) {
            Instance instance = (Instance)tuple.get(0);
            regressor.update((Double)instance.label, instance.features);
        }
        state.multiPut(KeysUtil.toKeys(this.classifierName), Arrays.asList(regressor));
    }
}

