/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.nlp;

import backtype.storm.tuple.Values;
import com.github.pmerienne.trident.ml.core.TextInstance;
import com.github.pmerienne.trident.ml.nlp.TextClassifier;
import com.github.pmerienne.trident.ml.util.KeysUtil;
import java.util.ArrayList;
import java.util.List;
import storm.trident.operation.TridentCollector;
import storm.trident.state.BaseQueryFunction;
import storm.trident.state.map.MapState;
import storm.trident.tuple.TridentTuple;

public class ClassifyTextQuery<L>
extends BaseQueryFunction<MapState<TextClassifier<L>>, L> {
    private static final long serialVersionUID = -9046858936834644113L;
    private String classifierName;

    public ClassifyTextQuery(String classifierName) {
        this.classifierName = classifierName;
    }

    public List<L> batchRetrieve(MapState<TextClassifier<L>> state, List<TridentTuple> tuples) {
        ArrayList labels = new ArrayList();
        List classifiers = state.multiGet(KeysUtil.toKeys(this.classifierName));
        if (classifiers != null && !classifiers.isEmpty()) {
            TextClassifier classifier = (TextClassifier)classifiers.get(0);
            for (TridentTuple tuple : tuples) {
                TextInstance instance = (TextInstance)tuple.get(0);
                Object label = classifier.classify(instance.tokens);
                labels.add(label);
            }
        }
        return labels;
    }

    public void execute(TridentTuple tuple, L result, TridentCollector collector) {
        collector.emit((List)new Values(new Object[]{result}));
    }
}

