/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.clustering;

import com.github.pmerienne.trident.ml.clustering.Clusterer;
import com.github.pmerienne.trident.ml.util.MathUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class KMeans
implements Clusterer,
Serializable {
    private static final long serialVersionUID = 338231277453149972L;
    private List<Long> counts = null;
    private double[][] centroids;
    private List<double[]> initFeatures = new ArrayList<double[]>();
    private Integer nbCluster;

    public KMeans(Integer nbCluster) {
        this.nbCluster = nbCluster;
    }

    @Override
    public Integer classify(double[] features) {
        if (!this.isReady()) {
            throw new IllegalStateException("KMeans is not ready yet");
        }
        Integer nearestCentroidIndex = this.nearestCentroid(features);
        return nearestCentroidIndex;
    }

    @Override
    public Integer update(double[] features) {
        if (!this.isReady()) {
            this.initIfPossible(features);
            return null;
        }
        Integer nearestCentroid = this.classify(features);
        this.counts.set(nearestCentroid, this.counts.get(nearestCentroid) + 1L);
        double[] update = MathUtil.mult(MathUtil.subtract(features, this.centroids[nearestCentroid]), 1.0 / (double)this.counts.get(nearestCentroid).longValue());
        this.centroids[nearestCentroid.intValue()] = MathUtil.add(this.centroids[nearestCentroid], update);
        return nearestCentroid;
    }

    @Override
    public double[] distribution(double[] features) {
        if (!this.isReady()) {
            throw new IllegalStateException("KMeans is not ready yet");
        }
        double[] distribution = new double[this.nbCluster.intValue()];
        for (int i = 0; i < this.nbCluster; ++i) {
            double[] currentCentroid = this.centroids[i];
            distribution[i] = MathUtil.euclideanDistance(currentCentroid, features);
        }
        return distribution;
    }

    @Override
    public double[][] getCentroids() {
        return this.centroids;
    }

    protected Integer nearestCentroid(double[] features) {
        Integer nearestCentroidIndex = 0;
        Double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < this.centroids.length; ++i) {
            Double currentDistance;
            double[] currentCentroid = this.centroids[i];
            if (currentCentroid == null || !((currentDistance = Double.valueOf(MathUtil.euclideanDistance(currentCentroid, features))) < minDistance)) continue;
            minDistance = currentDistance;
            nearestCentroidIndex = i;
        }
        return nearestCentroidIndex;
    }

    protected boolean isReady() {
        boolean countsReady = this.counts != null;
        boolean centroidsReady = this.centroids != null;
        return countsReady && centroidsReady;
    }

    protected void initIfPossible(double[] features) {
        this.initFeatures.add(features);
        if (this.initFeatures.size() >= 10 * this.nbCluster) {
            this.initCentroids();
        }
    }

    protected void initCentroids() {
        this.counts = new ArrayList<Long>(this.nbCluster);
        for (int i = 0; i < this.nbCluster; ++i) {
            this.counts.add(0L);
        }
        this.centroids = new double[this.nbCluster.intValue()][];
        Random random = new Random();
        double[] firstCentroid = this.initFeatures.remove(random.nextInt(this.initFeatures.size()));
        this.centroids[0] = firstCentroid;
        block1: for (int j = 1; j < this.nbCluster; ++j) {
            double[] dxs = this.computeDxs();
            double r = random.nextDouble() * dxs[dxs.length - 1];
            for (int i = 0; i < dxs.length; ++i) {
                if (!(dxs[i] >= r)) continue;
                double[] features = this.initFeatures.remove(i);
                this.centroids[j] = features;
                continue block1;
            }
        }
        this.initFeatures.clear();
    }

    protected double[] computeDxs() {
        double[] dxs = new double[this.initFeatures.size()];
        int sum = 0;
        for (int i = 0; i < this.initFeatures.size(); ++i) {
            double[] features = this.initFeatures.get(i);
            int nearestCentroidIndex = this.nearestCentroid(features);
            double[] nearestCentroid = this.centroids[nearestCentroidIndex];
            sum = (int)((double)sum + Math.pow(MathUtil.euclideanDistance(features, nearestCentroid), 2.0));
            dxs[i] = sum;
        }
        return dxs;
    }

    @Override
    public void reset() {
        this.counts = null;
        this.centroids = null;
        this.initFeatures = new ArrayList<double[]>();
    }
}

