/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.clustering;

import backtype.storm.tuple.Values;
import com.github.pmerienne.trident.ml.clustering.Clusterer;
import com.github.pmerienne.trident.ml.core.Instance;
import com.github.pmerienne.trident.ml.util.KeysUtil;
import java.util.ArrayList;
import java.util.List;
import storm.trident.operation.TridentCollector;
import storm.trident.state.BaseQueryFunction;
import storm.trident.state.map.MapState;
import storm.trident.tuple.TridentTuple;

public class ClusterQuery
extends BaseQueryFunction<MapState<Clusterer>, Integer> {
    private static final long serialVersionUID = -2431540558642267325L;
    private String clustererName;

    public ClusterQuery(String clustererName) {
        this.clustererName = clustererName;
    }

    public List<Integer> batchRetrieve(MapState<Clusterer> state, List<TridentTuple> tuples) {
        ArrayList<Integer> clusterIndexes = new ArrayList<Integer>();
        List clusterers = state.multiGet(KeysUtil.toKeys(this.clustererName));
        if (clusterers != null && !clusterers.isEmpty()) {
            Clusterer clusterer = (Clusterer)clusterers.get(0);
            for (TridentTuple tuple : tuples) {
                Instance instance = (Instance)tuple.get(0);
                Integer clustererIndex = clusterer.classify(instance.features);
                clusterIndexes.add(clustererIndex);
            }
        }
        return clusterIndexes;
    }

    public void execute(TridentTuple tuple, Integer result, TridentCollector collector) {
        collector.emit((List)new Values(new Object[]{result}));
    }
}

