/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.testing;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import com.github.pmerienne.trident.ml.core.Instance;
import com.github.pmerienne.trident.ml.testing.data.Datasets;
import java.util.List;
import java.util.Map;
import storm.trident.operation.TridentCollector;
import storm.trident.spout.IBatchSpout;

public class RandomFeaturesForClusteringSpout
implements IBatchSpout {
    private static final long serialVersionUID = -5293861317274377258L;
    private int maxBatchSize = 10;
    private int featureSize = 3;
    private int nbClasses = 3;
    private boolean withLabel = true;

    public RandomFeaturesForClusteringSpout() {
    }

    public RandomFeaturesForClusteringSpout(boolean withLabel) {
        this.withLabel = withLabel;
    }

    public RandomFeaturesForClusteringSpout(boolean withLabel, int featureSize) {
        this.withLabel = withLabel;
        this.featureSize = featureSize;
    }

    public RandomFeaturesForClusteringSpout(boolean withLabel, int featureSize, int nbClasses) {
        this.withLabel = withLabel;
        this.featureSize = featureSize;
        this.nbClasses = nbClasses;
    }

    public void open(Map conf, TopologyContext context) {
    }

    public void emitBatch(long batchId, TridentCollector collector) {
        List<Instance<Integer>> instances = Datasets.generateDataForMultiLabelClassification(this.maxBatchSize, this.featureSize, this.nbClasses);
        for (Instance<Integer> instance : instances) {
            Values values = new Values();
            if (this.withLabel) {
                values.add(instance.label);
            }
            for (int i = 0; i < instance.features.length; ++i) {
                values.add((Object)instance.features[i]);
            }
            collector.emit((List)values);
        }
    }

    public void ack(long batchId) {
    }

    public void close() {
    }

    public Map getComponentConfiguration() {
        return null;
    }

    public Fields getOutputFields() {
        String[] fieldNames;
        if (this.withLabel) {
            fieldNames = new String[this.featureSize + 1];
            fieldNames[0] = "label";
            for (int i = 0; i < this.featureSize; ++i) {
                fieldNames[i + 1] = "x" + i;
            }
        } else {
            fieldNames = new String[this.featureSize];
            for (int i = 0; i < this.featureSize; ++i) {
                fieldNames[i] = "x" + i;
            }
        }
        return new Fields(fieldNames);
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getFeatureSize() {
        return this.featureSize;
    }

    public void setFeatureSize(int featureSize) {
        this.featureSize = featureSize;
    }

    public boolean isWithLabel() {
        return this.withLabel;
    }

    public void setWithLabel(boolean withLabel) {
        this.withLabel = withLabel;
    }
}

