/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.stats;

import com.github.pmerienne.trident.ml.stats.StreamFeatureStatistics;
import java.io.Serializable;

public class FixedStreamFeatureStatistics
implements StreamFeatureStatistics,
Serializable {
    private static final long serialVersionUID = -7406184811401750690L;
    private long count = 0L;
    private double mean = 0.0;
    private double m2 = 0.0;

    @Override
    public void update(double feature) {
        ++this.count;
        double delta = feature - this.mean;
        this.mean += delta / (double)this.count;
        this.m2 += delta * (feature - this.mean);
    }

    @Override
    public Long getCount() {
        return this.count;
    }

    @Override
    public Double getMean() {
        return this.mean;
    }

    @Override
    public Double getVariance() {
        return this.m2 / (double)(this.count - 1L);
    }

    @Override
    public Double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    public String toString() {
        return "SimpleStreamFeatureStatistics [m2=" + this.m2 + ", count=" + this.count + ", mean=" + this.mean + ", variance=" + this.getVariance() + ", stdDev=" + this.getStdDev() + "]";
    }
}

