/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.stats;

import com.github.pmerienne.trident.ml.stats.StreamFeatureStatistics;
import java.io.Serializable;
import java.util.LinkedList;

public class AdaptiveStreamFeatureStatistics
implements StreamFeatureStatistics,
Serializable {
    private static final long serialVersionUID = 6267199325838362436L;
    private long maxSize = 1000L;
    private LinkedList<Double> features = new LinkedList();
    private long count = 0L;
    private double sum = 0.0;
    private double squaresSum = 0.0;

    public AdaptiveStreamFeatureStatistics() {
    }

    public AdaptiveStreamFeatureStatistics(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public void update(double feature) {
        ++this.count;
        this.features.add(feature);
        this.sum += feature;
        this.squaresSum += Math.pow(feature, 2.0);
        if ((long)this.features.size() > this.maxSize) {
            double first = this.features.removeFirst();
            this.sum -= first;
            this.squaresSum -= Math.pow(first, 2.0);
        }
    }

    @Override
    public Long getCount() {
        return this.count;
    }

    @Override
    public Double getMean() {
        return this.sum / (double)this.features.size();
    }

    @Override
    public Double getVariance() {
        return Math.pow(this.getStdDev(), 2.0);
    }

    @Override
    public Double getStdDev() {
        return Math.sqrt(this.squaresSum / (double)this.features.size() - Math.pow(this.sum / (double)this.features.size(), 2.0));
    }

    public String toString() {
        return "AdaptiveStreamFeatureStatistics [maxSize=" + this.maxSize + ", features=" + this.features + ", sum=" + this.sum + ", squaresSum=" + this.squaresSum + ", count=" + this.count + ", mean=" + this.getMean() + ", variance=" + this.getVariance() + ", stdDev=" + this.getStdDev() + "]";
    }
}

