/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.regression;

import com.github.pmerienne.trident.ml.regression.Regressor;
import com.github.pmerienne.trident.ml.util.MathUtil;

public class PARegressor
implements Regressor {
    private static final long serialVersionUID = -5163481593640555140L;
    private double[] weights;
    private Double epsilon = 0.01;

    public PARegressor() {
    }

    public PARegressor(Double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public Double predict(double[] features) {
        if (this.weights == null) {
            this.init(features.length);
        }
        Double prediction = MathUtil.dot(features, this.weights);
        return prediction;
    }

    @Override
    public void update(Double expected, double[] features) {
        if (this.weights == null) {
            this.init(features.length);
        }
        Double prediction = this.predict(features);
        double sign = expected - prediction > 0.0 ? 1.0 : -1.0;
        double loss = Math.max(0.0, Math.abs(prediction - expected) - this.epsilon);
        double update = loss / Math.pow(MathUtil.norm(features), 2.0);
        double[] scaledFeatures = MathUtil.mult(features, update * sign);
        this.weights = MathUtil.add(this.weights, scaledFeatures);
    }

    protected void init(int featureSize) {
        this.weights = new double[featureSize];
    }

    @Override
    public void reset() {
        this.weights = null;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public Double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(Double epsilon) {
        this.epsilon = epsilon;
    }

    public String toString() {
        return "PARegressor [epsilon=" + this.epsilon + "]";
    }
}

