/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.nlp;

import com.google.common.base.Functions;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Vocabulary
implements Iterable<String>,
Serializable {
    private static final long serialVersionUID = 7827671824674205961L;
    private TreeMap<String, Integer> wordCounts = new ValueComparableMap<String, Integer>(Ordering.natural().reverse());
    private Integer size = 0;

    public Vocabulary() {
    }

    public Vocabulary(List<String> words) {
        this.addAll(words);
    }

    public void add(String word) {
        Integer n;
        Serializable serializable;
        Integer actualCount = this.wordCounts.get(word);
        if (actualCount == null) {
            actualCount = 1;
        } else {
            serializable = actualCount;
            n = actualCount = Integer.valueOf(actualCount + 1);
        }
        this.wordCounts.put(word, actualCount);
        serializable = this;
        n = ((Vocabulary)serializable).size;
        Integer n2 = ((Vocabulary)serializable).size = Integer.valueOf(((Vocabulary)serializable).size + 1);
    }

    public void addAll(List<String> words) {
        for (String word : words) {
            this.add(word);
        }
    }

    public void limitWords(Integer maxWords) {
        while (this.wordCount() > maxWords) {
            String lessFrequentWord = this.wordCounts.lastKey();
            Integer lowestCount = this.wordCounts.remove(lessFrequentWord);
            Vocabulary vocabulary = this;
            Integer.valueOf(vocabulary.size - lowestCount);
            vocabulary.size = vocabulary.size;
        }
    }

    public Integer count(String word) {
        Integer actualCount = this.wordCounts.get(word);
        if (actualCount == null) {
            actualCount = 0;
        }
        return actualCount;
    }

    public Double frequency(String word) {
        return this.count(word).doubleValue() / this.size.doubleValue();
    }

    public Boolean contains(String word) {
        return this.wordCounts.containsKey(word);
    }

    public Integer wordCount() {
        return this.wordCounts.size();
    }

    public Integer totalCount() {
        return this.size;
    }

    @Override
    public Iterator<String> iterator() {
        return this.wordCounts.keySet().iterator();
    }

    public Set<String> wordSet() {
        return this.wordCounts.keySet();
    }

    public String toString() {
        return "Vocabulary [size=" + this.size + ", wordCounts=" + this.wordCounts + "]";
    }

    private static class ValueComparableMap<K extends Comparable<K>, V>
    extends TreeMap<K, V> {
        private static final long serialVersionUID = 1476556231893371136L;
        private final Map<K, V> valueMap;

        ValueComparableMap(Ordering<? super V> partialValueOrdering) {
            this(partialValueOrdering, new HashMap());
        }

        private ValueComparableMap(Ordering<? super V> partialValueOrdering, HashMap<K, V> valueMap) {
            super(partialValueOrdering.onResultOf(Functions.forMap(valueMap)).compound((Comparator)Ordering.natural()));
            this.valueMap = valueMap;
        }

        @Override
        public V get(Object key) {
            return this.valueMap.get(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.valueMap.containsKey(key);
        }

        @Override
        public V put(K k, V v) {
            if (this.valueMap.containsKey(k)) {
                super.remove(k);
            }
            this.valueMap.put(k, v);
            return super.put(k, v);
        }

        @Override
        public V remove(Object key) {
            super.remove(key);
            return this.valueMap.remove(key);
        }
    }
}

