/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.clustering;

import com.github.pmerienne.trident.ml.clustering.Clusterer;
import com.github.pmerienne.trident.ml.core.Instance;
import com.github.pmerienne.trident.ml.util.KeysUtil;
import java.util.Arrays;
import java.util.List;
import storm.trident.operation.TridentCollector;
import storm.trident.state.BaseStateUpdater;
import storm.trident.state.map.MapState;
import storm.trident.tuple.TridentTuple;

public class ClusterUpdater
extends BaseStateUpdater<MapState<Clusterer>> {
    private static final long serialVersionUID = -1580744366864902217L;
    private String clustererName;
    private Clusterer initialClusterer;

    public ClusterUpdater(String clustererName, Clusterer initialClusterer) {
        this.clustererName = clustererName;
        this.initialClusterer = initialClusterer;
    }

    public void updateState(MapState<Clusterer> state, List<TridentTuple> tuples, TridentCollector collector) {
        List clusterers = state.multiGet(KeysUtil.toKeys(this.clustererName));
        Clusterer clusterer = null;
        if (clusterers != null && !clusterers.isEmpty()) {
            clusterer = (Clusterer)clusterers.get(0);
        }
        if (clusterer == null) {
            clusterer = this.initialClusterer;
        }
        for (TridentTuple tuple : tuples) {
            Instance instance = (Instance)tuple.get(0);
            clusterer.update(instance.features);
        }
        state.multiPut(KeysUtil.toKeys(this.clustererName), Arrays.asList(clusterer));
    }

    public String getClustererName() {
        return this.clustererName;
    }

    public void setClustererName(String clustererName) {
        this.clustererName = clustererName;
    }

    public Clusterer getInitialClusterer() {
        return this.initialClusterer;
    }

    public void setInitialClusterer(Clusterer initialClusterer) {
        this.initialClusterer = initialClusterer;
    }

    public String toString() {
        return "ClusterUpdater [clustererName=" + this.clustererName + ", initialClusterer=" + this.initialClusterer + "]";
    }
}

