/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.state.util;

import java.util.Arrays;
import java.util.List;
import storm.trident.state.map.MapState;

public class MapStateUtil {
    public static <T> void putSingle(MapState<T> state, Object singleKey, T value) {
        List<List<Object>> keys = MapStateUtil.toKeys(singleKey);
        List<Object> values = Arrays.asList(value);
        state.multiPut(keys, values);
    }

    public static <T> void putSingle(MapState<T> state, Object key1, Object key2, T value) {
        List<List> keys = Arrays.asList(Arrays.asList(key1, key2));
        List<Object> values = Arrays.asList(value);
        state.multiPut(keys, values);
    }

    public static <T> T getSingle(MapState<T> state, Object singleKey) {
        List<List<Object>> keys = MapStateUtil.toKeys(singleKey);
        List values = state.multiGet(keys);
        T value = MapStateUtil.singleValue(values);
        return value;
    }

    public static <T> T getSingle(MapState<T> state, Object key1, Object key2) {
        List<List> keys = Arrays.asList(Arrays.asList(key1, key2));
        List values = state.multiGet(keys);
        T value = MapStateUtil.singleValue(values);
        return value;
    }

    public static <T> T singleValue(List<T> values) {
        return values != null && !values.isEmpty() ? (T)values.get(0) : null;
    }

    public static List<List<Object>> toKeys(Object singleKey) {
        List<List<Object>> keys = Arrays.asList(Arrays.asList(singleKey));
        return keys;
    }
}

