/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.state.redis;

import backtype.storm.task.IMetricsContext;
import com.github.pmerienne.trident.state.ExtendedStateFactory;
import com.github.pmerienne.trident.state.SparseMatrixState;
import com.github.pmerienne.trident.state.redis.AbstractRedisState;
import com.github.pmerienne.trident.state.redis.RedisConfig;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import redis.clients.jedis.Jedis;
import storm.trident.state.Serializer;
import storm.trident.state.State;

public class RedisSparseMatrixState<T>
extends AbstractRedisState<T>
implements SparseMatrixState<T> {
    private static final String COLUMN_KEY = "column";
    private static final String ROW_KEY = "row";

    public RedisSparseMatrixState(String id) {
        super(id);
    }

    public RedisSparseMatrixState(String id, RedisConfig config) {
        super(id, config);
    }

    @Override
    public T get(long i, long j) {
        String rowKey;
        Jedis jedis = (Jedis)this.pool.getResource();
        String serializedValue = jedis.hget(rowKey = this.getRowKey(j), Long.toString(i));
        if (StringUtils.isBlank((String)serializedValue)) {
            return null;
        }
        Object value = this.serializer.deserialize(serializedValue.getBytes());
        return (T)value;
    }

    @Override
    public void set(long i, long j, T value) {
        String columnKey = this.getColumnKey(i);
        String rowKey = this.getRowKey(j);
        this.set(rowKey, i, value);
        this.set(columnKey, j, value);
    }

    protected void set(String key, long index, T value) {
        Jedis jedis = (Jedis)this.pool.getResource();
        String field = Long.toString(index);
        if (value != null) {
            byte[] serializedValue = this.serializer.serialize(value);
            jedis.hset(key, field, new String(serializedValue));
        } else {
            jedis.hdel(key, new String[]{field});
        }
    }

    @Override
    public SparseMatrixState.SparseVector<T> getColumn(long i) {
        Jedis jedis = (Jedis)this.pool.getResource();
        String columnKey = this.getColumnKey(i);
        Map serializedResults = jedis.hgetAll(columnKey);
        RedisSparseVector column = new RedisSparseVector(serializedResults, this.serializer);
        return column;
    }

    @Override
    public SparseMatrixState.SparseVector<T> getRow(long j) {
        Jedis jedis = (Jedis)this.pool.getResource();
        String rowKey = this.getRowKey(j);
        Map serializedResults = jedis.hgetAll(rowKey);
        RedisSparseVector row = new RedisSparseVector(serializedResults, this.serializer);
        return row;
    }

    protected String getColumnKey(long i) {
        List<Object> keys = Arrays.asList(COLUMN_KEY, Long.toString(i));
        return this.generateKey(keys);
    }

    protected String getRowKey(long j) {
        List<Object> keys = Arrays.asList(ROW_KEY, Long.toString(j));
        return this.generateKey(keys);
    }

    public void beginCommit(Long txid) {
    }

    public void commit(Long txid) {
    }

    protected static class RedisSparseVector<T>
    implements SparseMatrixState.SparseVector<T> {
        private static final long serialVersionUID = 3559058694806143009L;
        private Map<String, String> values = new HashMap<String, String>();
        protected Serializer<T> serializer;

        public RedisSparseVector() {
        }

        public RedisSparseVector(Map<String, String> values, Serializer<T> serializer) {
            this.values = values;
            this.serializer = serializer;
        }

        @Override
        public T get(long i) {
            String serializedValue = this.values.get(Long.toString(i));
            if (StringUtils.isBlank((String)serializedValue)) {
                return null;
            }
            return (T)this.serializer.deserialize(serializedValue.getBytes());
        }

        @Override
        public void set(long i, T value) {
            String key = Long.toString(i);
            if (value != null) {
                String serializedValue = new String(this.serializer.serialize(value));
                this.values.put(key, serializedValue);
            } else {
                this.values.remove(key);
            }
        }

        @Override
        public Set<Long> indexes() {
            return Sets.newTreeSet((Iterable)Iterables.transform(this.values.keySet(), (Function)new Function<String, Long>(){

                public Long apply(String string) {
                    return Long.parseLong(string);
                }
            }));
        }
    }

    public static class Factory<T>
    implements ExtendedStateFactory<RedisSparseMatrixState<T>> {
        private static final long serialVersionUID = 4718043951532492603L;
        private final String id;

        public Factory() {
            this.id = UUID.randomUUID().toString();
        }

        public Factory(String id) {
            this.id = id;
        }

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            RedisSparseMatrixState state = new RedisSparseMatrixState(this.id, new RedisConfig((Map<?, ?>)conf));
            return state;
        }
    }
}

