/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.state.redis;

import backtype.storm.task.IMetricsContext;
import com.github.pmerienne.trident.state.ExtendedStateFactory;
import com.github.pmerienne.trident.state.redis.AbstractRedisState;
import com.github.pmerienne.trident.state.redis.RedisConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import redis.clients.jedis.Jedis;
import storm.trident.state.State;
import storm.trident.state.ValueUpdater;
import storm.trident.state.map.MapState;

public class RedisMapState<T>
extends AbstractRedisState<T>
implements MapState<T> {
    public RedisMapState(String id) {
        super(id);
    }

    public RedisMapState(String id, RedisConfig config) {
        super(id, config);
    }

    public void beginCommit(Long txid) {
    }

    public void commit(Long txid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> multiGet(List<List<Object>> keys) {
        ArrayList<Object> results = new ArrayList<Object>();
        String[] stringKeys = new String[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            stringKeys[i] = this.generateKey(keys.get(i));
        }
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            List resultsAsString = jedis.mget(stringKeys);
            for (String result : resultsAsString) {
                if (result == null || result.isEmpty()) {
                    results.add(null);
                    continue;
                }
                results.add(this.serializer.deserialize(result.getBytes()));
            }
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiPut(List<List<Object>> keys, List<T> vals) {
        String[] keyValues = new String[keys.size() * 2];
        for (int i = 0; i < keys.size(); ++i) {
            keyValues[i * 2] = this.generateKey(keys.get(i));
            keyValues[i * 2 + 1] = new String(this.serializer.serialize(vals.get(i)));
        }
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            jedis.mset(keyValues);
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
    }

    public List<T> multiUpdate(List<List<Object>> keys, List<ValueUpdater> updaters) {
        List<T> curr = this.multiGet(keys);
        ArrayList<Object> ret = new ArrayList<Object>(curr.size());
        for (int i = 0; i < curr.size(); ++i) {
            T currVal = curr.get(i);
            ValueUpdater updater = updaters.get(i);
            ret.add(updater.update(currVal));
        }
        this.multiPut(keys, ret);
        return ret;
    }

    public static class Factory<T>
    implements ExtendedStateFactory<RedisMapState<T>> {
        private static final long serialVersionUID = 4718043951532492603L;
        private final String id;

        public Factory() {
            this.id = UUID.randomUUID().toString();
        }

        public Factory(String id) {
            this.id = id;
        }

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            RedisMapState state = new RedisMapState(this.id, new RedisConfig((Map<?, ?>)conf));
            return state;
        }
    }
}

