/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.state.redis;

import backtype.storm.task.IMetricsContext;
import com.github.pmerienne.trident.state.ExtendedStateFactory;
import com.github.pmerienne.trident.state.MapMultimapState;
import com.github.pmerienne.trident.state.redis.AbstractRedisState;
import com.github.pmerienne.trident.state.redis.RedisConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import redis.clients.jedis.Jedis;
import storm.trident.state.Serializer;
import storm.trident.state.State;

public class RedisMapMultimapState<K1, K2, V>
extends AbstractRedisState<V>
implements MapMultimapState<K1, K2, V> {
    private final Serializer<K2> keySerializer;

    public RedisMapMultimapState(String id) {
        super(id);
        this.keySerializer = this.config.getSerializer();
    }

    public RedisMapMultimapState(String id, RedisConfig config) {
        super(id, config);
        this.keySerializer = config.getSerializer();
    }

    public void beginCommit(Long txid) {
    }

    public void commit(Long txid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(K1 key, K2 subkey, V value) {
        long result;
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            String stringKey = this.generateKey(key);
            String stringSubKey = new String(this.keySerializer.serialize(subkey));
            result = jedis.hset(stringKey, stringSubKey, new String(this.serializer.serialize(value)));
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return result >= 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K1 key, K2 subkey) {
        Jedis jedis = (Jedis)this.pool.getResource();
        Object result = null;
        try {
            String stringKey = this.generateKey(key);
            String stringSubKey = new String(this.keySerializer.serialize(subkey));
            String resultAsString = jedis.hget(stringKey, stringSubKey);
            if (resultAsString != null && !resultAsString.isEmpty()) {
                result = this.serializer.deserialize(resultAsString.getBytes());
            }
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return (V)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K2, V> getAll(K1 key) {
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            String stringKey = this.generateKey(key);
            Map resultsAsString = jedis.hgetAll(stringKey);
            for (String stringSubkey : resultsAsString.keySet()) {
                Object subkey = this.keySerializer.deserialize(stringSubkey.getBytes());
                Object value = this.serializer.deserialize(((String)resultsAsString.get(stringSubkey)).getBytes());
                results.put(subkey, value);
            }
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return results;
    }

    public static class Factory<K1, K2, V>
    implements ExtendedStateFactory<RedisMapMultimapState<K1, K2, V>> {
        private static final long serialVersionUID = 4718043951532492603L;
        private final String id;

        public Factory() {
            this.id = UUID.randomUUID().toString();
        }

        public Factory(String id) {
            this.id = id;
        }

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            RedisMapMultimapState state = new RedisMapMultimapState(this.id, new RedisConfig((Map<?, ?>)conf));
            return state;
        }
    }
}

