/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.state.memory;

import backtype.storm.task.IMetricsContext;
import com.github.pmerienne.trident.state.ExtendedStateFactory;
import com.github.pmerienne.trident.state.SparseMatrixState;
import com.github.pmerienne.trident.state.memory.TransactionalMemoryMapState;
import com.github.pmerienne.trident.state.util.MapStateUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import storm.trident.state.State;

public class MemorySparseMatrixState<T>
extends TransactionalMemoryMapState<Map<Long, T>>
implements SparseMatrixState<T> {
    private static final String COLUMN_KEY = "column:";
    private static final String ROW_KEY = "row:";

    public MemorySparseMatrixState(String id) {
        super(id);
    }

    @Override
    public T get(long i, long j) {
        Map column = (Map)MapStateUtil.getSingle(this, COLUMN_KEY + i);
        return column == null ? null : (T)column.get(j);
    }

    @Override
    public void set(long i, long j, T value) {
        HashMap<Long, T> column = (HashMap<Long, T>)MapStateUtil.getSingle(this, COLUMN_KEY + i);
        column = column == null ? new HashMap<Long, T>() : new HashMap(column);
        column.put(j, value);
        MapStateUtil.putSingle(this, COLUMN_KEY + i, column);
        HashMap<Long, T> row = (HashMap<Long, T>)MapStateUtil.getSingle(this, ROW_KEY + j);
        row = row == null ? new HashMap<Long, T>() : new HashMap(row);
        row.put(i, value);
        MapStateUtil.putSingle(this, ROW_KEY + j, row);
    }

    @Override
    public SparseMatrixState.SparseVector<T> getColumn(long i) {
        Map column = (Map)MapStateUtil.getSingle(this, COLUMN_KEY + i);
        return new MemorySparseVector(column);
    }

    @Override
    public SparseMatrixState.SparseVector<T> getRow(long j) {
        Map row = (Map)MapStateUtil.getSingle(this, ROW_KEY + j);
        return new MemorySparseVector(row);
    }

    public static class MemorySparseVector<T>
    extends TreeMap<Long, T>
    implements SparseMatrixState.SparseVector<T> {
        private static final long serialVersionUID = -2504979784781091836L;

        public MemorySparseVector() {
        }

        public MemorySparseVector(Map<Long, T> map) {
            super(map);
        }

        @Override
        public T get(long i) {
            return (T)this.get((Object)i);
        }

        @Override
        public void set(long i, T value) {
            this.put(i, value);
        }

        @Override
        public Set<Long> indexes() {
            return this.keySet();
        }
    }

    public static class Factory<T>
    implements ExtendedStateFactory<MemorySparseMatrixState<T>> {
        private static final long serialVersionUID = 4957447552599428092L;
        private final String id;

        public Factory() {
            this.id = UUID.randomUUID().toString();
        }

        public Factory(String id) {
            this.id = id;
        }

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            MemorySparseMatrixState state = new MemorySparseMatrixState(this.id);
            return state;
        }
    }
}

