/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.state.memory;

import backtype.storm.task.IMetricsContext;
import com.github.pmerienne.trident.state.ExtendedStateFactory;
import com.github.pmerienne.trident.state.SortedSetMultiMapState;
import com.github.pmerienne.trident.state.memory.TransactionalMemoryMapState;
import com.github.pmerienne.trident.state.util.MapStateUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import storm.trident.state.State;

public class MemorySortedSetMultiMapState<K, T>
extends TransactionalMemoryMapState<TreeSet<SortedSetMultiMapState.ScoredValue<T>>>
implements SortedSetMultiMapState<K, T> {
    public MemorySortedSetMultiMapState(String id) {
        super(id);
    }

    @Override
    public long sizeOf(K key) {
        TreeSet<SortedSetMultiMapState.ScoredValue<T>> set = this.get(key);
        return set == null ? 0L : (long)set.size();
    }

    @Override
    public boolean put(K key, SortedSetMultiMapState.ScoredValue<T> scoredValue) {
        TreeSet<SortedSetMultiMapState.ScoredValue<T>> set = this.get(key);
        boolean result = set.add(scoredValue);
        MapStateUtil.putSingle(this, key, set);
        return result;
    }

    @Override
    public List<SortedSetMultiMapState.ScoredValue<T>> getSorted(K key, int count) {
        TreeSet<SortedSetMultiMapState.ScoredValue<T>> set = this.get(key);
        ArrayList<SortedSetMultiMapState.ScoredValue<T>> results = new ArrayList<SortedSetMultiMapState.ScoredValue<T>>(count);
        int i = 0;
        Iterator<SortedSetMultiMapState.ScoredValue<T>> it = set.descendingIterator();
        while (it.hasNext() && i < count) {
            results.add(it.next());
        }
        return results;
    }

    @Override
    public double getScore(K key, T value) {
        TreeSet<SortedSetMultiMapState.ScoredValue<T>> set = this.get(key);
        if (set == null || set.isEmpty()) {
            return 0.0;
        }
        Double score = null;
        Iterator<SortedSetMultiMapState.ScoredValue<T>> it = set.iterator();
        while (it.hasNext() && score == null) {
            SortedSetMultiMapState.ScoredValue<T> current = it.next();
            if (!current.getValue().equals(value)) continue;
            score = current.getScore();
        }
        return score == null ? 0.0 : score;
    }

    protected TreeSet<SortedSetMultiMapState.ScoredValue<T>> get(K key) {
        TreeSet value = (TreeSet)MapStateUtil.getSingle(this, key);
        return value == null ? new TreeSet<SortedSetMultiMapState.ScoredValue<T>>() : new TreeSet(value);
    }

    public static class Factory<K, T>
    implements ExtendedStateFactory<MemorySortedSetMultiMapState<K, T>> {
        private static final long serialVersionUID = 8867957095217639678L;
        private final String id;

        public Factory() {
            this.id = UUID.randomUUID().toString();
        }

        public Factory(String id) {
            this.id = id;
        }

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            return new MemorySortedSetMultiMapState(this.id);
        }
    }
}

