/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.state.memory;

import backtype.storm.task.IMetricsContext;
import com.github.pmerienne.trident.state.ExtendedStateFactory;
import com.github.pmerienne.trident.state.SetState;
import com.github.pmerienne.trident.state.memory.TransactionalMemoryMapState;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import storm.trident.state.State;

public class MemorySetState<T>
extends TransactionalMemoryMapState<Set<T>>
implements SetState<T> {
    public MemorySetState(String id) {
        super(id);
    }

    @Override
    public Set<T> get() {
        Set set = (Set)super.get();
        return set == null ? new HashSet() : new HashSet(set);
    }

    @Override
    public boolean add(T e) {
        Object set = this.get();
        boolean result = set.add(e);
        this.set(set);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Object set = this.get();
        boolean result = set.addAll(c);
        this.set(set);
        return result;
    }

    @Override
    public void clear() {
        this.set(new HashSet());
    }

    public static class Factory<T>
    implements ExtendedStateFactory<MemorySetState<T>> {
        private static final long serialVersionUID = 4769786989416998195L;
        private final String _id;

        public Factory() {
            this._id = UUID.randomUUID().toString();
        }

        public Factory(String _id) {
            this._id = _id;
        }

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            return new MemorySetState(this._id);
        }
    }
}

