/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.state;

import com.github.pmerienne.trident.state.ExtendedState;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public interface SortedSetMultiMapState<K, V>
extends ExtendedState<V> {
    public long sizeOf(K var1);

    public boolean put(K var1, ScoredValue<V> var2);

    public List<ScoredValue<V>> getSorted(K var1, int var2);

    public double getScore(K var1, V var2);

    public static class ScoredValue<V>
    implements Comparable<ScoredValue<V>> {
        private final double score;
        private final V value;

        public ScoredValue(double score, V value) {
            this.score = score;
            this.value = value;
        }

        public double getScore() {
            return this.score;
        }

        public V getValue() {
            return this.value;
        }

        @Override
        public int compareTo(ScoredValue<V> o) {
            if (o == null) {
                return 1;
            }
            if (this.score != o.score) {
                return Double.compare(this.score, o.score);
            }
            return ScoredValue.compare(this.getValue(), o.getValue());
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.value).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ScoredValue)) {
                return false;
            }
            ScoredValue other = (ScoredValue)obj;
            return new EqualsBuilder().append(this.value, other.value).isEquals();
        }

        public static <V> int compare(V k1, V k2) {
            if (k1 instanceof Comparable) {
                return ((Comparable)k1).compareTo(k2);
            }
            return 0;
        }
    }
}

