/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.state.redis;

import com.github.pmerienne.trident.state.serializer.JsonValueSerializer;
import java.util.HashMap;
import java.util.Map;
import storm.trident.state.Serializer;

public class RedisConfig
extends HashMap<String, String> {
    private static final long serialVersionUID = -1913847520446822065L;
    public static final String HOST = "redis.port";
    public static final String PORT = "redis.host";
    public static final String PASSWORD = "redis.password";
    public static final String KEY_PREFIX = "redis.key.prefix";
    public static final String KEY_SEPARATOR = "redis.key.separator";
    public static final String TIMEOUT = "redis.timeout";
    public static final String DATABASE = "redis.database";
    public static final String SERIALIZER = "redis.serializer";
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PASSWORD = null;
    public static final String DEFAULT_KEY_PREFIX = "state";
    public static final String DEFAULT_KEY_SEPARATOR = ":";
    public static final String DEFAULT_SERIALIZER = JsonValueSerializer.class.getName();

    public RedisConfig() {
    }

    public RedisConfig(Map<?, ?> conf) {
        for (Object key : conf.keySet()) {
            Object value = conf.get(key);
            this.put(key instanceof String ? (String)key : key.toString(), value instanceof String ? (String)value : value.toString());
        }
    }

    public String getHost() {
        return this.getString(HOST, DEFAULT_HOST);
    }

    public void setHost(String host) {
        this.put(HOST, host);
    }

    public Integer getPort() {
        return this.getInteger(PORT, 6379);
    }

    public void setPort(Integer port) {
        this.put(PORT, Integer.toString(port));
    }

    public String getPassword() {
        return this.getString(PASSWORD, DEFAULT_PASSWORD);
    }

    public void setPassword(String password) {
        this.put(PASSWORD, password);
    }

    public String getKeyPrefix() {
        return this.getString(KEY_PREFIX, DEFAULT_KEY_PREFIX);
    }

    public void setKeyPrefix(String keyPrefix) {
        this.put(KEY_PREFIX, keyPrefix);
    }

    public String getKeySeparator() {
        return this.getString(KEY_SEPARATOR, DEFAULT_KEY_SEPARATOR);
    }

    public void setKeySeparator(String keySeparator) {
        this.put(KEY_SEPARATOR, keySeparator);
    }

    public Integer getTimeout() {
        return this.getInteger(TIMEOUT, 2000);
    }

    public void setTimeout(Integer timeout) {
        this.put(TIMEOUT, Integer.toString(timeout));
    }

    public Integer getDatabase() {
        return this.getInteger(DATABASE, 0);
    }

    public void setDatabase(Integer database) {
        this.put(DATABASE, Integer.toString(database));
    }

    public <T> Serializer<T> getSerializer() {
        String serializerClass = this.getString(SERIALIZER, DEFAULT_SERIALIZER);
        try {
            Class<?> clazz = Class.forName(serializerClass);
            return (Serializer)clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setSerializer(Class<Serializer<?>> serializerClass) {
        this.put(SERIALIZER, serializerClass.getName());
    }

    private String getString(String key, String defaultValue) {
        return this.containsKey(key) ? (String)this.get(key) : defaultValue;
    }

    private Integer getInteger(String key, Integer defaultValue) {
        return this.containsKey(key) ? Integer.parseInt((String)this.get(key)) : defaultValue;
    }
}

