/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.state.memory;

import backtype.storm.task.IMetricsContext;
import com.github.pmerienne.trident.state.MapMultimapState;
import com.github.pmerienne.trident.state.memory.TransactionalMemoryMapState;
import com.github.pmerienne.trident.state.util.MapStateUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import storm.trident.state.State;
import storm.trident.state.StateFactory;

public class MemoryMapMultimapState<K1, K2, V>
extends TransactionalMemoryMapState<Map<K2, V>>
implements MapMultimapState<K1, K2, V> {
    public MemoryMapMultimapState(String id) {
        super(id);
    }

    @Override
    public boolean put(K1 key, K2 subkey, V value) {
        Map<K2, V> all = this.getAll(key);
        V previous = all.put(subkey, value);
        MapStateUtil.putSingle(this, key, all);
        return previous == null;
    }

    @Override
    public V get(K1 key, K2 subkey) {
        Map<K2, V> all = this.getAll(key);
        return all.get(subkey);
    }

    @Override
    public Map<K2, V> getAll(K1 key) {
        Map map = (Map)MapStateUtil.getSingle(this, key);
        return map == null ? new HashMap() : map;
    }

    public static class Factory
    implements StateFactory {
        private static final long serialVersionUID = -6865870100536320916L;
        private final String id = UUID.randomUUID().toString();

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            return new MemoryMapMultimapState(this.id);
        }
    }
}

