/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.testing;

import backtype.storm.Config;
import backtype.storm.LocalCluster;
import backtype.storm.LocalDRPC;
import backtype.storm.utils.Utils;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import storm.trident.TridentTopology;
import stormy.pythian.testing.FixedInstanceSpout;

public abstract class TridentIntegrationTest {
    protected LocalDRPC localDRPC;
    protected LocalCluster cluster;
    protected TridentTopology topology;
    protected Config config;

    @Before
    public void init() {
        this.cluster = new LocalCluster();
        this.localDRPC = new LocalDRPC();
        this.topology = new TridentTopology();
        this.config = new Config();
    }

    @After
    public void release() {
        this.cluster.shutdown();
        this.localDRPC.shutdown();
    }

    protected void launch() {
        this.cluster.submitTopology(this.getClass().getSimpleName(), (Map)this.config, this.topology.build());
    }

    protected void launchAndWait(FixedInstanceSpout spout) {
        this.launch();
        this.wait(spout);
    }

    protected void wait(FixedInstanceSpout spout) {
        while (!spout.allInstancesProcessed()) {
            Utils.sleep((long)10L);
        }
    }
}

