/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.state.memory;

import backtype.storm.task.IMetricsContext;
import java.util.Map;
import storm.trident.state.State;
import storm.trident.state.StateFactory;
import storm.trident.testing.MemoryMapState;
import stormy.pythian.model.annotation.Documentation;
import stormy.pythian.model.annotation.Property;
import stormy.pythian.model.component.PythianState;
import stormy.pythian.state.TransactionMode;

@Documentation(name="In memory state", description="Stores state in memory. This state is not meant to be used in production environnement.")
public class InMemoryPythianState
implements PythianState {
    private static final long serialVersionUID = 8586345043929881545L;
    @Property(name="Transaction mode")
    private TransactionMode transactionMode;
    @Property(name="Name", description="This name will is used to identify the state. It should be unique")
    private String name;

    public StateFactory createStateFactory() {
        switch (this.transactionMode) {
            case TRANSACTIONAL: {
                return new TransactionalInMemoryStateFactory(this.name);
            }
            case NONE: {
                return new NoneTransactionalInMemoryStateFactory(this.name);
            }
            case OPAQUE: {
                return new OpaqueTransactionalInMemoryStateFactory(this.name);
            }
        }
        throw new IllegalStateException("Unsupported transaction mode : " + (Object)((Object)this.transactionMode));
    }

    public static class TransactionalInMemoryStateFactory
    extends InMemoryStateFactory {
        private static final long serialVersionUID = -6512983913668194068L;

        public TransactionalInMemoryStateFactory(String uuid) {
            super(uuid);
        }

        @Override
        protected State createState(String uuid) {
            return new MemoryMapState(uuid);
        }
    }

    public static class OpaqueTransactionalInMemoryStateFactory
    extends InMemoryStateFactory {
        private static final long serialVersionUID = -6433397890576750143L;

        public OpaqueTransactionalInMemoryStateFactory(String uuid) {
            super(uuid);
        }

        @Override
        protected State createState(String uuid) {
            return new MemoryMapState(uuid);
        }
    }

    public static class NoneTransactionalInMemoryStateFactory
    extends InMemoryStateFactory {
        private static final long serialVersionUID = 7032563580553707943L;

        public NoneTransactionalInMemoryStateFactory(String uuid) {
            super(uuid);
        }

        @Override
        protected State createState(String uuid) {
            return new MemoryMapState(uuid);
        }
    }

    public static abstract class InMemoryStateFactory
    implements StateFactory {
        private static final long serialVersionUID = -3589505813476300002L;
        private final String uuid;

        public InMemoryStateFactory(String uuid) {
            this.uuid = uuid;
        }

        public String getUuid() {
            return this.uuid;
        }

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            return this.createState(this.uuid);
        }

        protected abstract State createState(String var1);

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InMemoryStateFactory other = (InMemoryStateFactory)obj;
            return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
        }
    }
}

