/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.service.topology;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import stormy.pythian.core.configuration.PythianToplogyConfiguration;
import stormy.pythian.service.topology.TopologyRepository;

@Service
public class TopologyService {
    @Autowired
    private TopologyRepository repository;

    public PythianToplogyConfiguration save(PythianToplogyConfiguration topology) {
        Preconditions.checkNotNull((Object)topology, (Object)"topology is mandatory");
        topology.ensureId();
        this.repository.save(topology);
        return topology;
    }

    public void delete(String topologyId) {
        Preconditions.checkNotNull((Object)topologyId, (Object)"topology's id is mandatory");
        this.repository.delete(topologyId);
    }

    public Collection<PythianToplogyConfiguration> findAll() {
        return this.repository.findAll();
    }

    public PythianToplogyConfiguration findById(String topologyId) {
        Preconditions.checkNotNull((Object)topologyId, (Object)"topology's id is mandatory");
        return this.repository.findById(topologyId);
    }
}

