/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.service.topology;

import backtype.storm.LocalCluster;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import stormy.pythian.core.configuration.PythianToplogyConfiguration;
import stormy.pythian.core.topology.PythianTopology;
import stormy.pythian.service.topology.TopologyRepository;

@Service
public class TopologyLocalLauncherService {
    @Autowired
    private TopologyRepository topologyRepository;
    private LocalCluster cluster;

    @PostConstruct
    protected void initLocalCluster() {
        this.cluster = new LocalCluster();
    }

    @PreDestroy
    protected void shutdownLocalCluster() {
        this.cluster.shutdown();
    }

    public void launch(String topologyId) {
        this.cluster.killTopology(topologyId);
        PythianToplogyConfiguration configuration = this.topologyRepository.findById(topologyId);
        PythianTopology pythianTopology = new PythianTopology();
        pythianTopology.build(configuration);
        this.cluster.submitTopology(topologyId, (Map)pythianTopology.getTridentConfig(), pythianTopology.getStormTopology());
    }

    public void kill(String topologyId) {
        this.cluster.killTopology(topologyId);
    }
}

