/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.service.description;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import stormy.pythian.core.description.ComponentDescription;
import stormy.pythian.core.description.ComponentDescriptionFactory;
import stormy.pythian.model.annotation.ComponentType;
import stormy.pythian.model.component.Component;
import stormy.pythian.service.description.ClassRepository;

@Service
public class DescriptionService {
    @Autowired
    private ComponentDescriptionFactory descriptionFactory;
    @Autowired
    private ClassRepository classRepository;

    public Map<ComponentType, Collection<ComponentDescription>> findAllComponentDescriptions() {
        Set<Class<? extends Component>> componentClasses = this.classRepository.getComponentClasses();
        HashMultimap componentDescriptions = HashMultimap.create();
        for (Class<? extends Component> componentClass : componentClasses) {
            ComponentDescription description = this.descriptionFactory.createDeclaration(componentClass);
            componentDescriptions.put((Object)description.getType(), (Object)description);
        }
        return componentDescriptions.asMap();
    }
}

