/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.service.description;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;
import stormy.pythian.model.component.Component;

@Repository
public class ClassRepository {
    private Reflections reflections;
    @Value(value="${component.base.package:stormy.pyhtian}")
    private String basePackage;

    @PostConstruct
    public void loadReflections() {
        this.reflections = new Reflections(this.basePackage, new Scanner[0]);
    }

    public Set<Class<? extends Component>> getComponentClasses() {
        return Sets.filter((Set)this.reflections.getSubTypesOf(Component.class), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return !Modifier.isAbstract(input.getModifiers());
            }
        });
    }
}

