/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.model.instance;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import stormy.pythian.model.instance.FeaturesIndex;

public class OutputUserSelectionFeaturesMapper
implements Serializable {
    private static final long serialVersionUID = 6993554834452684410L;
    private final FeaturesIndex featuresIndex;
    private final int[] newFeatureIndexes;

    public OutputUserSelectionFeaturesMapper(FeaturesIndex featuresIndex, Collection<String> newFeatures) {
        this.featuresIndex = featuresIndex;
        this.newFeatureIndexes = new int[newFeatures.size()];
        int i = 0;
        for (String newFeature : newFeatures) {
            int selectedIndex;
            this.newFeatureIndexes[i] = selectedIndex = featuresIndex.getIndex(newFeature);
            ++i;
        }
    }

    public int size() {
        return this.featuresIndex.size();
    }

    public int[] getNewFeatureIndexes() {
        return this.newFeatureIndexes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.featuresIndex == null ? 0 : this.featuresIndex.hashCode());
        result = 31 * result + Arrays.hashCode(this.newFeatureIndexes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutputUserSelectionFeaturesMapper other = (OutputUserSelectionFeaturesMapper)obj;
        if (this.featuresIndex == null ? other.featuresIndex != null : !this.featuresIndex.equals(other.featuresIndex)) {
            return false;
        }
        return Arrays.equals(this.newFeatureIndexes, other.newFeatureIndexes);
    }

    public String toString() {
        return "OutputUserSelectionFeaturesMapper [featuresIndex=" + this.featuresIndex + ", newFeatureIndexes=" + Arrays.toString(this.newFeatureIndexes) + "]";
    }
}

