/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.model.instance;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FeaturesIndex
implements Serializable {
    private static final long serialVersionUID = 4675835465674004328L;
    private final Map<String, Integer> mapping;

    public FeaturesIndex() {
        this.mapping = new HashMap<String, Integer>();
    }

    public FeaturesIndex(Map<String, Integer> mapping) {
        this.mapping = mapping;
    }

    public FeaturesIndex(Collection<String> features) {
        this.mapping = new HashMap<String, Integer>(features.size());
        for (String feature : features) {
            this.mapping.put(feature, this.mapping.size());
        }
    }

    public int getIndex(String featureName) {
        Integer index = this.mapping.get(featureName);
        return index == null ? -1 : index;
    }

    public int size() {
        return this.mapping.size();
    }

    public String toString() {
        return "FeaturesIndex [mapping=" + this.mapping + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mapping == null ? 0 : this.mapping.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeaturesIndex other = (FeaturesIndex)obj;
        return !(this.mapping == null ? other.mapping != null : !this.mapping.equals(other.mapping));
    }

    public static class Builder {
        private final Map<String, Integer> mapping;

        public Builder() {
            this.mapping = new HashMap<String, Integer>();
        }

        public Builder(Map<String, Integer> mapping) {
            this.mapping = new HashMap<String, Integer>(mapping);
        }

        public static Builder featuresIndex() {
            return new Builder();
        }

        public static Builder from(FeaturesIndex index) {
            return new Builder(index.mapping);
        }

        public Builder with(String feature) {
            this.mapping.put(feature, this.mapping.size());
            return this;
        }

        public Builder with(Collection<String> features) {
            for (String feature : features) {
                this.with(feature);
            }
            return this;
        }

        public FeaturesIndex build() {
            return new FeaturesIndex(this.mapping);
        }
    }
}

