/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.component.statistic.aggregation;

import backtype.storm.tuple.Values;
import java.io.Serializable;
import java.util.List;
import storm.trident.operation.BaseFunction;
import storm.trident.operation.CombinerAggregator;
import storm.trident.operation.TridentCollector;
import storm.trident.tuple.TridentTuple;
import stormy.pythian.model.instance.InputFixedFeaturesMapper;
import stormy.pythian.model.instance.Instance;

public class StatisticAggregator<T>
implements CombinerAggregator<T> {
    private static final long serialVersionUID = -5948600275983221714L;
    private final InputFixedFeaturesMapper inputMapper;
    private final AggregableStatistic<T> aggregableStatistic;

    public StatisticAggregator(InputFixedFeaturesMapper inputMapper, AggregableStatistic<T> aggregableStatistic) {
        this.inputMapper = inputMapper;
        this.aggregableStatistic = aggregableStatistic;
    }

    public T init(TridentTuple tuple) {
        Instance instance = Instance.from((TridentTuple)tuple);
        Number feature = (Number)instance.getInputFeature(this.inputMapper, "Computed feature");
        if (feature != null) {
            T statistic = this.aggregableStatistic.init(feature);
            return statistic;
        }
        return this.zero();
    }

    public T combine(T val1, T val2) {
        val1 = val1 != null ? val1 : this.zero();
        val2 = val2 != null ? val2 : this.zero();
        return this.aggregableStatistic.combine(val1, val2);
    }

    public T zero() {
        return this.aggregableStatistic.zero();
    }

    public static class AddStatisticFeatures<T>
    extends BaseFunction {
        private static final long serialVersionUID = 2405388485852452769L;
        private final AggregableStatistic<T> aggregableStatistic;

        public AddStatisticFeatures(AggregableStatistic<T> aggregableStatistic) {
            this.aggregableStatistic = aggregableStatistic;
        }

        public void execute(TridentTuple tuple, TridentCollector collector) {
            Instance original = Instance.from((TridentTuple)tuple);
            Object statistic = tuple.getValueByField("STATISTIC_FIELD");
            Instance newInstance = this.aggregableStatistic.update(original, statistic);
            collector.emit((List)new Values(new Object[]{newInstance}));
        }
    }

    public static interface AggregableStatistic<T>
    extends Serializable {
        public T init(Number var1);

        public T combine(T var1, T var2);

        public T zero();

        public Instance update(Instance var1, T var2);
    }
}

